<!DOCTYPE html>
<!-- Generated by pkgdown: do not edit by hand --><html lang="en"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Draw a map which represents positions of different chromosomes on the curve — hc_map-GenomicHilbertCurve-method • HilbertCurve</title><!-- jquery --><script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script><!-- Bootstrap --><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/css/bootstrap.min.css" integrity="sha256-bZLfwXAP04zRMK2BjiO8iu9pf4FbLqX6zitd+tIvLhE=" crossorigin="anonymous"><script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/js/bootstrap.min.js" integrity="sha256-nuL8/2cJ5NDSSwnKD8VqreErSWHtnEP9E7AySL+1ev4=" crossorigin="anonymous"></script><!-- bootstrap-toc --><link rel="stylesheet" href="../bootstrap-toc.css"><script src="../bootstrap-toc.js"></script><!-- Font Awesome icons --><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/all.min.css" integrity="sha256-mmgLkCYLUQbXn0B1SRqzHar6dCnv9oZFPEC1g1cwlkk=" crossorigin="anonymous"><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/v4-shims.min.css" integrity="sha256-wZjR52fzng1pJHwx4aV2AO3yyTOXrcDW7jBpJtTwVxw=" crossorigin="anonymous"><!-- clipboard.js --><script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.6/clipboard.min.js" integrity="sha256-inc5kl9MA1hkeYUt+EC3BhlIgyp/2jDIyBLS6k3UxPI=" crossorigin="anonymous"></script><!-- headroom.js --><script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.11.0/headroom.min.js" integrity="sha256-AsUX4SJE1+yuDu5+mAVzJbuYNPHj/WroHuZ8Ir/CkE0=" crossorigin="anonymous"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.11.0/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script><!-- pkgdown --><link href="../pkgdown.css" rel="stylesheet"><script src="../pkgdown.js"></script><meta property="og:title" content="Draw a map which represents positions of different chromosomes on the curve — hc_map-GenomicHilbertCurve-method"><meta property="og:description" content="Draw a map which represents positions of different chromosomes on the curve"><!-- mathjax --><script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script><!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]--></head><body data-spy="scroll" data-target="#toc">
    

    <div class="container template-reference-topic">
      <header><div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">HilbertCurve</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="">1.99.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav"><li>
  <a href="../articles/examples.html">Examples</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu"><li class="dropdown-header">Vignettes</li>
    <li>
      <a href="../articles/hc_general.html">Making 2D Hilbert Curve</a>
    </li>
    <li>
      <a href="../articles/hc_genome.html">GenomicHilbertCurve: specific for genomic data</a>
    </li>
    <li>
      <a href="../articles/cpan.html">Visualize CPAN modules with Hilbert curve</a>
    </li>
  </ul></li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
      </ul><ul class="nav navbar-nav navbar-right"><li>
  <a href="https://github.com/jokergoo/HilbertCurve/" class="external-link">
    <span class="fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul></div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header><div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Draw a map which represents positions of different chromosomes on the curve</h1>
    
    <div class="hidden name"><code>hc_map-GenomicHilbertCurve-method.rd</code></div>
    </div>

    <div class="ref-description">
    <p>Draw a map which represents positions of different chromosomes on the curve</p>
    </div>

    <div id="ref-usage">
    <div class="sourceCode"><pre class="sourceCode r"><code><span><span class="co"># S4 method for GenomicHilbertCurve</span></span>
<span><span class="fu">hc_map</span><span class="op">(</span><span class="va">object</span>, level <span class="op">=</span> <span class="fl">7</span>,</span>
<span>    fill <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/circlize/man/rand_color.html" class="external-link">rand_color</a></span><span class="op">(</span><span class="fu"><a href="https://rdrr.io/r/base/length.html" class="external-link">length</a></span><span class="op">(</span><span class="va">background</span><span class="op">)</span>, transparency <span class="op">=</span> <span class="fl">0.5</span><span class="op">)</span>, border <span class="op">=</span> <span class="cn">NA</span>,</span>
<span>    labels <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/names.html" class="external-link">names</a></span><span class="op">(</span><span class="va">object</span><span class="op">@</span><span class="va">background</span><span class="op">)</span>, show_labels <span class="op">=</span> <span class="cn">TRUE</span>, labels_gp <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/grid/gpar.html" class="external-link">gpar</a></span><span class="op">(</span><span class="op">)</span>,</span>
<span>    add <span class="op">=</span> <span class="cn">FALSE</span>, <span class="va">...</span><span class="op">)</span></span></code></pre></div>
    </div>

    <div id="arguments">
    <h2>Arguments</h2>
    <dl><dt>object</dt>
<dd><p>a <code><a href="GenomicHilbertCurve-class.html">GenomicHilbertCurve-class</a></code> object</p></dd>

  <dt>level</dt>
<dd><p>Since a map does not need to have high resolution, a value of around 7 would be enough.  If <code>add</code> is set to <code>TRUE</code>, <code>level</code> will be enforced to have the same level in the current Hilbert curve.</p></dd>

  <dt>fill</dt>
<dd><p>colors for different chromosomes, or more generally, for different 'seqnames'.</p></dd>

  <dt>border</dt>
<dd><p>colors for the borders of chromosomes. Set it to <code>NA</code> if borders are suppressed.</p></dd>

  <dt>labels</dt>
<dd><p>label for each chromosome, or more generally, for different 'sequences'</p></dd>

  <dt>show_labels</dt>
<dd><p>whether show text labels</p></dd>

  <dt>labels_gp</dt>
<dd><p>graphic settings for labels</p></dd>

  <dt>add</dt>
<dd><p>whether add the map to the current curve or draw it in a new graphic device. Notice if <code>add</code> is set to <code>TRUE</code>, you should set <code>fill</code> with transparency so that it will not hide your original plot.</p></dd>

  <dt>...</dt>
<dd><p>pass to <code><a href="GenomicHilbertCurve.html">GenomicHilbertCurve</a></code>. It is only used if you want the map to be plotted in a new graphic device.</p></dd>


</dl></div>
    <div id="details">
    <h2>Details</h2>
    <p>When multiple genomic categories (e.g. chromosomes) are drawn into one single Hilbert curve, a map which shows the positions
of categories on the curve is necessary to distinguish different genomic categories.</p>
<p>Under "pixel" mode, if the map is directly added to the Hilbert curve, no chromosome name is drawn. The chromosome names
are only drawn if the map is plotted in a new graphic device or added to the Hilbert curve under "normal" mode.</p>
<p>Just be careful if you directly overlay the map to the curve that the color of the map does not affect the original
plot too much.</p>
    </div>
    <div id="value">
    <h2>Value</h2>
    

<p>A <code><a href="GenomicHilbertCurve-class.html">GenomicHilbertCurve-class</a></code> object</p>
    </div>
    <div id="author">
    <h2>Author</h2>
    <p>Zuguang Gu &lt;z.gu@dkfz.de&gt;</p>
    </div>

    <div id="ref-examples">
    <h2>Examples</h2>
    <div class="sourceCode"><pre class="sourceCode r"><code><span class="r-in"><span><span class="kw"><a href="https://rdrr.io/r/base/library.html" class="external-link">require</a></span><span class="op">(</span><span class="va"><a href="https://github.com/jokergoo/circlize" class="external-link">circlize</a></span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="kw"><a href="https://rdrr.io/r/base/library.html" class="external-link">require</a></span><span class="op">(</span><span class="va"><a href="https://bioconductor.org/packages/GenomicRanges" class="external-link">GenomicRanges</a></span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">bed</span> <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/circlize/man/generateRandomBed.html" class="external-link">generateRandomBed</a></span><span class="op">(</span>nr <span class="op">=</span> <span class="fl">100</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">gr</span> <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/GenomicRanges/man/GRanges-class.html" class="external-link">GRanges</a></span><span class="op">(</span>seqnames <span class="op">=</span> <span class="va">bed</span><span class="op">[[</span><span class="fl">1</span><span class="op">]</span><span class="op">]</span>, ranges <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/IRanges/man/IRanges-constructor.html" class="external-link">IRanges</a></span><span class="op">(</span><span class="va">bed</span><span class="op">[[</span><span class="fl">2</span><span class="op">]</span><span class="op">]</span>, <span class="va">bed</span><span class="op">[[</span><span class="fl">3</span><span class="op">]</span><span class="op">]</span><span class="op">)</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">hc</span> <span class="op">=</span> <span class="fu"><a href="GenomicHilbertCurve.html">GenomicHilbertCurve</a></span><span class="op">(</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="fu"><a href="hc_points-dispatch.html">hc_points</a></span><span class="op">(</span><span class="va">hc</span>, <span class="va">gr</span>, gp <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/grid/gpar.html" class="external-link">gpar</a></span><span class="op">(</span>fill <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/circlize/man/rand_color.html" class="external-link">rand_color</a></span><span class="op">(</span><span class="fu"><a href="https://rdrr.io/r/base/length.html" class="external-link">length</a></span><span class="op">(</span><span class="va">gr</span><span class="op">)</span><span class="op">)</span><span class="op">)</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="co"># add it in the same graphic device</span></span></span>
<span class="r-in"><span><span class="fu">hc_map</span><span class="op">(</span><span class="va">hc</span>, fill <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/circlize/man/rand_color.html" class="external-link">rand_color</a></span><span class="op">(</span><span class="fl">24</span>, transparency <span class="op">=</span> <span class="fl">0.5</span><span class="op">)</span>, add <span class="op">=</span> <span class="cn">TRUE</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="hc_map-GenomicHilbertCurve-method-1.png" alt="" width="700" height="433"></span>
<span class="r-in"><span></span></span>
<span class="r-in"><span><span class="co"># add the map only with borders</span></span></span>
<span class="r-in"><span><span class="va">hc</span> <span class="op">=</span> <span class="fu"><a href="GenomicHilbertCurve.html">GenomicHilbertCurve</a></span><span class="op">(</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="fu"><a href="hc_points-dispatch.html">hc_points</a></span><span class="op">(</span><span class="va">hc</span>, <span class="va">gr</span>, gp <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/grid/gpar.html" class="external-link">gpar</a></span><span class="op">(</span>fill <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/circlize/man/rand_color.html" class="external-link">rand_color</a></span><span class="op">(</span><span class="fu"><a href="https://rdrr.io/r/base/length.html" class="external-link">length</a></span><span class="op">(</span><span class="va">gr</span><span class="op">)</span><span class="op">)</span><span class="op">)</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="fu">hc_map</span><span class="op">(</span><span class="va">hc</span>, fill <span class="op">=</span> <span class="cn">NA</span>, border <span class="op">=</span> <span class="st">"grey"</span>, add <span class="op">=</span> <span class="cn">TRUE</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="hc_map-GenomicHilbertCurve-method-2.png" alt="" width="700" height="433"></span>
<span class="r-in"><span></span></span>
<span class="r-in"><span><span class="co"># or open a new graphic device</span></span></span>
<span class="r-in"><span><span class="fu">hc_map</span><span class="op">(</span><span class="va">hc</span>, fill <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/circlize/man/rand_color.html" class="external-link">rand_color</a></span><span class="op">(</span><span class="fl">24</span><span class="op">)</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="hc_map-GenomicHilbertCurve-method-3.png" alt="" width="700" height="433"></span>
</code></pre></div>
    </div>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="pkgdown-sidebar">
    <nav id="toc" data-toggle="toc" class="sticky-top"><h2 data-toc-skip>Contents</h2>
    </nav></div>
</div>


      <footer><div class="copyright">
  <p></p><p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p></p><p>Site built with <a href="https://pkgdown.r-lib.org/" class="external-link">pkgdown</a> 2.0.9.</p>
</div>

      </footer></div>

  


  <style>nav[data-toggle='toc'] .nav .nav {display: block;}</style></body></html>

