<!DOCTYPE html>
<!-- Generated by pkgdown: do not edit by hand --><html lang="en"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Initialize a Hilbert curve — HilbertCurve • HilbertCurve</title><!-- jquery --><script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script><!-- Bootstrap --><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/css/bootstrap.min.css" integrity="sha256-bZLfwXAP04zRMK2BjiO8iu9pf4FbLqX6zitd+tIvLhE=" crossorigin="anonymous"><script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/js/bootstrap.min.js" integrity="sha256-nuL8/2cJ5NDSSwnKD8VqreErSWHtnEP9E7AySL+1ev4=" crossorigin="anonymous"></script><!-- bootstrap-toc --><link rel="stylesheet" href="../bootstrap-toc.css"><script src="../bootstrap-toc.js"></script><!-- Font Awesome icons --><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/all.min.css" integrity="sha256-mmgLkCYLUQbXn0B1SRqzHar6dCnv9oZFPEC1g1cwlkk=" crossorigin="anonymous"><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/v4-shims.min.css" integrity="sha256-wZjR52fzng1pJHwx4aV2AO3yyTOXrcDW7jBpJtTwVxw=" crossorigin="anonymous"><!-- clipboard.js --><script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.6/clipboard.min.js" integrity="sha256-inc5kl9MA1hkeYUt+EC3BhlIgyp/2jDIyBLS6k3UxPI=" crossorigin="anonymous"></script><!-- headroom.js --><script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.11.0/headroom.min.js" integrity="sha256-AsUX4SJE1+yuDu5+mAVzJbuYNPHj/WroHuZ8Ir/CkE0=" crossorigin="anonymous"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.11.0/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script><!-- pkgdown --><link href="../pkgdown.css" rel="stylesheet"><script src="../pkgdown.js"></script><meta property="og:title" content="Initialize a Hilbert curve — HilbertCurve"><meta property="og:description" content="Initialize a Hilbert curve"><!-- mathjax --><script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script><!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]--></head><body data-spy="scroll" data-target="#toc">
    

    <div class="container template-reference-topic">
      <header><div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">HilbertCurve</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="">1.99.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav"><li>
  <a href="../articles/examples.html">Examples</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu"><li class="dropdown-header">Vignettes</li>
    <li>
      <a href="../articles/hc_general.html">Making 2D Hilbert Curve</a>
    </li>
    <li>
      <a href="../articles/hc_genome.html">GenomicHilbertCurve: specific for genomic data</a>
    </li>
    <li>
      <a href="../articles/cpan.html">Visualize CPAN modules with Hilbert curve</a>
    </li>
  </ul></li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
      </ul><ul class="nav navbar-nav navbar-right"><li>
  <a href="https://github.com/jokergoo/HilbertCurve/" class="external-link">
    <span class="fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul></div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header><div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Initialize a Hilbert curve</h1>
    
    <div class="hidden name"><code>HilbertCurve.rd</code></div>
    </div>

    <div class="ref-description">
    <p>Initialize a Hilbert curve</p>
    </div>

    <div id="ref-usage">
    <div class="sourceCode"><pre class="sourceCode r"><code><span><span class="fu">HilbertCurve</span><span class="op">(</span><span class="va">s</span>, <span class="va">e</span>, level <span class="op">=</span> <span class="fl">4</span>, mode <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"normal"</span>, <span class="st">"pixel"</span><span class="op">)</span>,</span>
<span>    reference <span class="op">=</span> <span class="cn">FALSE</span>, reference_gp <span class="op">=</span> <span class="fu">gpar</span><span class="op">(</span>lty <span class="op">=</span> <span class="fl">3</span>, col <span class="op">=</span> <span class="st">"#999999"</span><span class="op">)</span>,</span>
<span>    arrow <span class="op">=</span> <span class="cn">TRUE</span>, zoom <span class="op">=</span> <span class="cn">NULL</span>, newpage <span class="op">=</span> <span class="cn">TRUE</span>,</span>
<span>    background_col <span class="op">=</span> <span class="st">"transparent"</span>, background_border <span class="op">=</span> <span class="cn">NA</span>,</span>
<span>    title <span class="op">=</span> <span class="cn">NULL</span>, title_gp <span class="op">=</span> <span class="fu">gpar</span><span class="op">(</span>fontsize <span class="op">=</span> <span class="fl">16</span><span class="op">)</span>,</span>
<span>    start_from <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"bottomleft"</span>, <span class="st">"topleft"</span>, <span class="st">"bottomright"</span>, <span class="st">"topright"</span><span class="op">)</span>,</span>
<span>    first_seg <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"horizontal"</span>, <span class="st">"vertical"</span><span class="op">)</span>, legend <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/list.html" class="external-link">list</a></span><span class="op">(</span><span class="op">)</span>,</span>
<span>    padding <span class="op">=</span> <span class="fu">unit</span><span class="op">(</span><span class="fl">2</span>, <span class="st">"mm"</span><span class="op">)</span><span class="op">)</span></span></code></pre></div>
    </div>

    <div id="arguments">
    <h2>Arguments</h2>
    <dl><dt>s</dt>
<dd><p>position that will be mapped as the start of the Hilbert curve. The value should a single numeric value. If it is a vector, the minimum is used.</p></dd>

  <dt>e</dt>
<dd><p>position that will be mapped as the end of the Hilbert curve. The value should a single numeric value. If it is a vector, the maximum is used.</p></dd>

  <dt>level</dt>
<dd><p>iteration level of the Hilbert curve. There will by <code>4^level - 1</code> segments in the curve.</p></dd>

  <dt>mode</dt>
<dd><p>"normal" mode is used for low <code>level</code> value and "pixel" mode is always used for high <code>level</code> value, so the "normal" mode is always for low-resolution visualization while "pixel" mode is used for high-resolution visualization. See 'details' for explanation.</p></dd>

  <dt>reference</dt>
<dd><p>whether add reference lines on the plot. Only works under 'normal' mode. The reference line is only used for illustrating how the curve folds.</p></dd>

  <dt>reference_gp</dt>
<dd><p>graphic settings for the reference lines. It should be specified by <code><a href="https://rdrr.io/r/grid/gpar.html" class="external-link">gpar</a></code>.</p></dd>

  <dt>arrow</dt>
<dd><p>whether add arrows on the reference line. Only works under 'normal' mode.</p></dd>

  <dt>zoom</dt>
<dd><p>Internally, position are stored as integer values. To better map the data to the Hilbert curve,  the original positions are zoomed according to the range and the level of Hilbert curve. E.g. if  the curve visualizes data ranging from 1 to 2 but level of the curve is set to 4, the positions will be zoomed by ~x2000 so that values like 1.5, 1.555 can be mapped to the curve with more accuracy. You don't need to care the zooming thing,  proper zooming factor is calculated automatically.</p></dd>

  <dt>newpage</dt>
<dd><p>whether call <code><a href="https://rdrr.io/r/grid/grid.newpage.html" class="external-link">grid.newpage</a></code> to draw on a new graphic device.</p></dd>

  <dt>background_col</dt>
<dd><p>background color.</p></dd>

  <dt>background_border</dt>
<dd><p>background border border.</p></dd>

  <dt>title</dt>
<dd><p>title of the plot.</p></dd>

  <dt>title_gp</dt>
<dd><p>graphic parameters for the title. It should be specified by <code><a href="https://rdrr.io/r/grid/gpar.html" class="external-link">gpar</a></code>.</p></dd>

  <dt>start_from</dt>
<dd><p>which corner on the plot should the curve starts?</p></dd>

  <dt>first_seg</dt>
<dd><p>the orientation of the first segment.</p></dd>

  <dt>legend</dt>
<dd><p>a <code><a href="https://rdrr.io/r/grid/grid-defunct.html" class="external-link">grob</a></code> object, a <code><a href="https://rdrr.io/pkg/ComplexHeatmap/man/Legends-class.html" class="external-link">Legends-class</a></code> object, or a list of them.</p></dd>

  <dt>padding</dt>
<dd><p>padding around the Hilbert curve.</p></dd>


</dl></div>
    <div id="details">
    <h2>Details</h2>
    <p>This funciton initializes a Hilbert curve with level <code>level</code> which corresponds 
to the range between <code>s</code> and <code>e</code>.</p>
<p>Under 'normal' mode, there is a visible Hilbert curve which plays like a folded axis and
different low-level graphics can be added afterwards according to the coordinates. 
It works nice if the level of the Hilbert curve is small (say less than 6).</p>
<p>When the level is high (e.g. &gt; 10), the whole 2D space will be almost completely filled by the curve and
it is impossible to add or visualize e.g. points on the curve. In this case, the 'pixel'
mode visualizes each tiny 'segment' as a pixel and maps values to colors. Internally, the whole plot
is represented as an RGB matrix and every time a new layer is added to the plot, the RGB matrix
will be updated according to the color overlay. When all the layers are added, normally a PNG figure is generated
directly from the RGB matrix. So the Hilbert
curve with level 11 will generate a PNG figure with 2048x2048 resolution. This is extremely
useful for visualize genomic data. E.g. If we make a Hilbert curve for human chromosome 1 with
level 11, then each pixel can represent 60bp (<code>249250621/2048/2048</code>) which is of very high resolution.</p>
<p>Under 'pixel' mode, if the current device is an interactive deivce, every time a new layer is added, 
the image will be add to the interactive device as a rastered image. But still you can use <code><a href="hc_png-HilbertCurve-method.html">hc_png,HilbertCurve-method</a></code>
to export the plot as PNG file.</p>
<p>To make it short and clear, under "normal" mode, you can use following low-level graphic functions:</p>
<ul><li><p><code><a href="hc_points-HilbertCurve-method.html">hc_points,HilbertCurve-method</a></code></p></li>
<li><p><code><a href="hc_segments-HilbertCurve-method.html">hc_segments,HilbertCurve-method</a></code></p></li>
<li><p><code><a href="hc_rect-HilbertCurve-method.html">hc_rect,HilbertCurve-method</a></code></p></li>
<li><p><code><a href="hc_polygon-HilbertCurve-method.html">hc_polygon,HilbertCurve-method</a></code></p></li>
<li><p><code><a href="hc_text-HilbertCurve-method.html">hc_text,HilbertCurve-method</a></code></p></li>
</ul><p>And under "pixel" mode, you can use following functions:</p>
<ul><li><p><code><a href="hc_layer-HilbertCurve-method.html">hc_layer,HilbertCurve-method</a></code></p></li>
<li><p><code><a href="hc_png-HilbertCurve-method.html">hc_png,HilbertCurve-method</a></code></p></li>
<li><p><code><a href="hc_polygon-HilbertCurve-method.html">hc_polygon,HilbertCurve-method</a></code></p></li>
<li><p><code><a href="hc_text-HilbertCurve-method.html">hc_text,HilbertCurve-method</a></code></p></li>
</ul><p>Notice, <code>s</code> and <code>e</code> are not necessarily to be integers, it can be any values (e.g. numeric or even negative values).</p>
    </div>
    <div id="value">
    <h2>Value</h2>
    

<p>A <code><a href="HilbertCurve-class.html">HilbertCurve-class</a></code> object.</p>
    </div>
    <div id="author">
    <h2>Author</h2>
    <p>Zuguang Gu &lt;z.gu@dkfz.de&gt;</p>
    </div>

    <div id="ref-examples">
    <h2>Examples</h2>
    <div class="sourceCode"><pre class="sourceCode r"><code><span class="r-in"><span><span class="fu">HilbertCurve</span><span class="op">(</span><span class="fl">1</span>, <span class="fl">100</span>, reference <span class="op">=</span> <span class="cn">TRUE</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="HilbertCurve-1.png" alt="" width="700" height="433"></span>
<span class="r-in"><span><span class="fu">HilbertCurve</span><span class="op">(</span><span class="fl">1</span>, <span class="fl">100</span>, level <span class="op">=</span> <span class="fl">5</span>, reference <span class="op">=</span> <span class="cn">TRUE</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="HilbertCurve-2.png" alt="" width="700" height="433"></span>
<span class="r-in"><span><span class="fu">HilbertCurve</span><span class="op">(</span><span class="fl">1</span>, <span class="fl">100</span>, title <span class="op">=</span> <span class="st">"title"</span>, reference <span class="op">=</span> <span class="cn">TRUE</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="HilbertCurve-3.png" alt="" width="700" height="433"></span>
<span class="r-in"><span><span class="fu">HilbertCurve</span><span class="op">(</span><span class="fl">1</span>, <span class="fl">100</span>, start_from <span class="op">=</span> <span class="st">"topleft"</span>, reference <span class="op">=</span> <span class="cn">TRUE</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="HilbertCurve-4.png" alt="" width="700" height="433"></span>
<span class="r-in"><span></span></span>
<span class="r-in"><span><span class="co"># plot with one legend</span></span></span>
<span class="r-in"><span><span class="kw"><a href="https://rdrr.io/r/base/library.html" class="external-link">require</a></span><span class="op">(</span><span class="va"><a href="https://github.com/jokergoo/ComplexHeatmap" class="external-link">ComplexHeatmap</a></span><span class="op">)</span></span></span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> Loading required package: ComplexHeatmap</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> ========================================</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> ComplexHeatmap version 2.18.0</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> Bioconductor page: http://bioconductor.org/packages/ComplexHeatmap/</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> Github page: https://github.com/jokergoo/ComplexHeatmap</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> Documentation: http://jokergoo.github.io/ComplexHeatmap-reference</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> </span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> If you use it in published research, please cite either one:</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> - Gu, Z. Complex Heatmap Visualization. iMeta 2022.</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> - Gu, Z. Complex heatmaps reveal patterns and correlations in multidimensional </span>
<span class="r-msg co"><span class="r-pr">#&gt;</span>     genomic data. Bioinformatics 2016.</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> </span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> </span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> The new InteractiveComplexHeatmap package can directly export static </span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> complex heatmaps into an interactive Shiny app with zero effort. Have a try!</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> </span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> This message can be suppressed by:</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span>   suppressPackageStartupMessages(library(ComplexHeatmap))</span>
<span class="r-msg co"><span class="r-pr">#&gt;</span> ========================================</span>
<span class="r-in"><span><span class="va">legend</span> <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/ComplexHeatmap/man/Legend.html" class="external-link">Legend</a></span><span class="op">(</span>labels <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"a"</span>, <span class="st">"b"</span><span class="op">)</span>, title <span class="op">=</span> <span class="st">"foo"</span>, </span></span>
<span class="r-in"><span>    legend_gp <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/grid/gpar.html" class="external-link">gpar</a></span><span class="op">(</span>fill <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"red"</span>, <span class="st">"blue"</span><span class="op">)</span><span class="op">)</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">hc</span> <span class="op">=</span> <span class="fu">HilbertCurve</span><span class="op">(</span><span class="fl">1</span>, <span class="fl">100</span>, title <span class="op">=</span> <span class="st">"title"</span>, legend <span class="op">=</span> <span class="va">legend</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="fu"><a href="hc_segments-dispatch.html">hc_segments</a></span><span class="op">(</span><span class="va">hc</span>, x1 <span class="op">=</span> <span class="fl">20</span>, x2 <span class="op">=</span> <span class="fl">40</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="HilbertCurve-5.png" alt="" width="700" height="433"></span>
<span class="r-in"><span></span></span>
<span class="r-in"><span><span class="co"># plot with more than one legend</span></span></span>
<span class="r-in"><span><span class="kw"><a href="https://rdrr.io/r/base/library.html" class="external-link">require</a></span><span class="op">(</span><span class="va"><a href="https://github.com/jokergoo/circlize" class="external-link">circlize</a></span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">legend1</span> <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/ComplexHeatmap/man/Legend.html" class="external-link">Legend</a></span><span class="op">(</span>labels <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"a"</span>, <span class="st">"b"</span><span class="op">)</span>, title <span class="op">=</span> <span class="st">"foo"</span>, </span></span>
<span class="r-in"><span>    legend_gp <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/grid/gpar.html" class="external-link">gpar</a></span><span class="op">(</span>fill <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"red"</span>, <span class="st">"blue"</span><span class="op">)</span><span class="op">)</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">col_fun</span> <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/circlize/man/colorRamp2.html" class="external-link">colorRamp2</a></span><span class="op">(</span><span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="op">-</span><span class="fl">1</span>, <span class="fl">0</span>, <span class="fl">1</span><span class="op">)</span>, <span class="fu"><a href="https://rdrr.io/r/base/c.html" class="external-link">c</a></span><span class="op">(</span><span class="st">"green"</span>, <span class="st">"white"</span>, <span class="st">"red"</span><span class="op">)</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">legend2</span> <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/pkg/ComplexHeatmap/man/Legend.html" class="external-link">Legend</a></span><span class="op">(</span>col_fun <span class="op">=</span> <span class="va">col_fun</span>, title <span class="op">=</span> <span class="st">"bar"</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="va">hc</span> <span class="op">=</span> <span class="fu">HilbertCurve</span><span class="op">(</span><span class="fl">1</span>, <span class="fl">100</span>, title <span class="op">=</span> <span class="st">"title"</span>, legend <span class="op">=</span> <span class="fu"><a href="https://rdrr.io/r/base/list.html" class="external-link">list</a></span><span class="op">(</span><span class="va">legend1</span>, <span class="va">legend2</span><span class="op">)</span><span class="op">)</span></span></span>
<span class="r-in"><span><span class="fu"><a href="hc_segments-dispatch.html">hc_segments</a></span><span class="op">(</span><span class="va">hc</span>, x1 <span class="op">=</span> <span class="fl">20</span>, x2 <span class="op">=</span> <span class="fl">40</span><span class="op">)</span></span></span>
<span class="r-plt img"><img src="HilbertCurve-6.png" alt="" width="700" height="433"></span>
</code></pre></div>
    </div>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="pkgdown-sidebar">
    <nav id="toc" data-toggle="toc" class="sticky-top"><h2 data-toc-skip>Contents</h2>
    </nav></div>
</div>


      <footer><div class="copyright">
  <p></p><p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p></p><p>Site built with <a href="https://pkgdown.r-lib.org/" class="external-link">pkgdown</a> 2.0.9.</p>
</div>

      </footer></div>

  


  <style>nav[data-toggle='toc'] .nav .nav {display: block;}</style></body></html>

