% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotAPA.r
\name{plotMultiAPA}
\alias{plotMultiAPA}
\title{Draw aggregation plots for interactions with different distances.}
\usage{
plotMultiAPA(submatrices = NULL, ctrlSubmatrices = NULL, ..., plot.opts = NULL)
}
\arguments{
\item{submatrices}{\if{html}{\out{<listmatrix>}}: The matrices list to
separate using interaction distances and aggregate.
Chunks of distances are created with:
\code{c(0,50000*2 ^ seq(0,5,by=1))}.
Other matrices with distances over 1.6 Mb are aggregated in the same
final chunk.}

\item{ctrlSubmatrices}{\if{html}{\out{<listmatrix>}}: The matrices list to use
as control condition for differential aggregation.}

\item{...}{: Additional arguments to pass to
[Aggregation()].
For differential aggregation plot, \code{submatrices} will take the matrices
of the treated condition.
eg:

\if{html}{\out{<div class="sourceCode">}}\preformatted{plotMultiAPA(
submatrices = interactions_HS.mtx_lst,
ctrlSubmatrices = interactions_Ctrl.mtx_lst)```

[Aggregation()]: R:Aggregation()
}\if{html}{\out{</div>}}}

\item{plot.opts}{list of arguments to pass to \code{\link[=ggAPA]{ggAPA()}}.}
}
\value{
A plot with separate APAs per distance and a list of aggregated
matrices as invisible output.
}
\description{
Separates matrices based on interaction distance, performs
aggregation and plots Aggregated signal for each chunk of interaction
distances.
}
\details{
plotMultiAPA
}
\examples{
#' # Data
data(Beaf32_Peaks.gnr)
data(HiC_Ctrl.cmx_lst)
data(HiC_HS.cmx_lst)

# Index Beaf32
Beaf32_Index.gnr <- IndexFeatures(
    gRangeList = list(Beaf = Beaf32_Peaks.gnr),
    chromSizes = data.frame(seqnames = c("2L", "2R"),
        seqlengths = c(23513712, 25286936)),
    binSize = 100000
)

# Beaf32 <-> Beaf32 Pairing
Beaf_Beaf.gni <- SearchPairs(indexAnchor = Beaf32_Index.gnr)
Beaf_Beaf.gni <- Beaf_Beaf.gni[seq_len(2000)] # subset 2000 first for eg

# Matrices extractions center on Beaf32 <-> Beaf32 point interaction
interactions_Ctrl.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_Ctrl.cmx_lst,
    referencePoint = "pf"
)
interactions_HS.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_HS.cmx_lst,
    referencePoint = "pf"
)
interactions_Ctrl.mtx_lst <- PrepareMtxList(
    matrices = interactions_Ctrl.mtx_lst
)

# Aggregate matrices in one matrix
plotMultiAPA(submatrices = interactions_Ctrl.mtx_lst)


interactions_HS.mtx_lst <- PrepareMtxList(
    matrices = interactions_HS.mtx_lst
)

# Differential Aggregation
plotMultiAPA(
    submatrices = interactions_HS.mtx_lst,
    ctrlSubmatrices = interactions_Ctrl.mtx_lst,
    diffFun = "ratio",
    plot.opts = list(colors = list("blue","white","red"))
)

}
