% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndexFeatures.R
\name{IndexFeatures}
\alias{IndexFeatures}
\title{Indexes GRanges on genome.}
\usage{
IndexFeatures(
  gRangeList = NULL,
  genomicConstraint = NULL,
  chromSizes = NULL,
  binSize = NULL,
  method = "mean",
  metadataColName = NULL,
  cores = 1,
  verbose = FALSE
)
}
\arguments{
\item{gRangeList}{<GRanges or GRangesList or list\link{GRanges}>:
GRanges object, list of GRanges or GRangesList containing coordinates
to index.}

\item{genomicConstraint}{\if{html}{\out{<GRanges>}}: GRanges object of
constraint regions. Note that bins in the same constraint region only
will be paired in HicAggR::SearchPairs(). If NULL chromosomes in chromSizes
are used as constraints (Default NULL)}

\item{chromSizes}{<data.frame>: A data.frame containing
chromosomes names and lengths in base pairs (see example).}

\item{binSize}{\if{html}{\out{<integer>}}: Bin size in bp - corresponds to
matrix resolution.}

\item{method}{\if{html}{\out{<character>}}: A string defining which summary
method is used on metadata columns defined in metadataColName if multiple
ranges are indexed in the same bin. Use 'mean', 'median', 'sum', 'max' or
'min'. (Default 'mean'')}

\item{metadataColName}{\if{html}{\out{<character>}} : A character vector that
specify the metadata columns of GRanges on which to apply the summary
method if multiple ranges are indexed in the same bin.}

\item{cores}{\if{html}{\out{<integer>}} : Number of cores used. (Default 1)}

\item{verbose}{\if{html}{\out{<logical>}}: Show the progression in console?
(Default FALSE)}
}
\value{
A GRanges object.
}
\description{
Function that indexes a GRanges object on binned genome and
constraints. Needed prior HicAggR::SearchPairs() function.
Uses \code{GenomeInfoDb::\link[GenomeInfoDb]{seqlevelsStyle}} internally
so make sure you have the \pkg{GenomeInfoDb} package installed.
}
\details{
IndexFeatures
}
\examples{
data(Beaf32_Peaks.gnr)
Beaf32_Index.gnr <- IndexFeatures(
    gRangeList = list(Beaf = Beaf32_Peaks.gnr),
    chromSizes = data.frame(
        seqnames = c("2L", "2R"),
        seqlengths = c(23513712, 25286936)
    ),
    binSize = 100000
)

}
