% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICEnorm.R
\name{ICEnorm}
\alias{ICEnorm}
\title{Compute Iterative Correction.}
\usage{
ICEnorm(hic, qtlTh = 0.15, maxIter = 50)
}
\arguments{
\item{hic}{\if{html}{\out{<contactMatrix>}}: The HiC maps chunk to normalize.}

\item{qtlTh}{\if{html}{\out{<numerical>}}: The threshold quantile below which
the bins will be ignored. (Default 0.15)}

\item{maxIter}{\if{html}{\out{<numerical>}}: The maximum iteration number.}
}
\value{
A normalized contactMatrix
}
\description{
Compute Iterative Correction (Vanilla Count) on hic maps.
}
\details{
ICEnorm
}
\examples{
data(HiC_Ctrl.cmx_lst)
HiC_Ctrl_ICE.cmx <- ICEnorm(HiC_Ctrl.cmx_lst[['2L_2L']])

}
