% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetQuantif.R
\name{GetQuantif}
\alias{GetQuantif}
\title{Compute quantification on extracted submatrices.}
\usage{
GetQuantif(
  matrices,
  areaFun = "center",
  operationFun = "mean_rm0",
  varName = NULL
)
}
\arguments{
\item{matrices}{<List\link{matrix}>: A matrices list.}

\item{areaFun}{\if{html}{\out{<character or function>}}: A character or
function that allows to extract an area from each matrix that composes
the matrices list (Default "center").
\itemize{
\item "C" or "CENTER": 3x3 pixels at the intersection between anchor and
bait.
\item "UL" or "UPPER_LEFT": pixels in the uppper left square
\item "UR" or "UPPER_RIGHT": pixels in the uppper right square
\item "BL" or "BOTTOM_LEFT": pixels in the bottom left square
\item "BR" or "BOTTOM_RIGHT": pixels in the bottom right square
\item "U" or "UPPER": pixels above the center area
\item "B" or "BOTTOM": pixels below the center area
\item "L" or "LEFT": pixels in the left of the center area
\item "R" or "RIGHT": pixels in the right of the center area
\item "D" or "DONUT": pixels that surrounds the center area
}}

\item{operationFun}{\if{html}{\out{<character or function>}}: A character or
function specifying the operation applied to the selected area.
(Default "mean_rm0")
\itemize{
\item "mean_rm0": apply a mean after replacing 0 with NA
\item "median_rm0": apply a median after replacing 0 with NA
\item "sum_rm0": apply a sum after replacing 0 with NA
\item "median": apply a median
\item "sum": apply a sum
\item "mean" or other character: apply a mean
}}

\item{varName}{\if{html}{\out{<character>}}: The name of a column in
GInteraction attributes of matrices used as named in the output vector
(Default NULL). By default, sub-matrices IDs are used.}
}
\value{
A GRange object.
}
\description{
Function that computes quantification of contact frequencies
in a given area and returns it in a named vector.
}
\details{
GetQuantif
}
\examples{
# Data
data(Beaf32_Peaks.gnr)
data(HiC_Ctrl.cmx_lst)

# Index Beaf32
Beaf32_Index.gnr <- IndexFeatures(
    gRangeList = list(Beaf = Beaf32_Peaks.gnr),
    chromSizes = data.frame(
        seqnames = c("2L", "2R"),
        seqlengths = c(23513712, 25286936)
    ),
    binSize = 100000
)

# Beaf32 <-> Beaf32 Pairing
Beaf_Beaf.gni <- SearchPairs(indexAnchor = Beaf32_Index.gnr)
Beaf_Beaf.gni <- Beaf_Beaf.gni[seq_len(2000)] # subset 2000 first for exemple

# Matrices extractions center on Beaf32 <-> Beaf32 point interaction
interactions_PF.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_Ctrl.cmx_lst,
    referencePoint = "pf"
)
GetQuantif(
    matrices = interactions_PF.mtx_lst,
    areaFun = "center",
    operationFun = "mean"
) |> head()

}
