% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_getSignature.R
\name{pmgetSignature}
\alias{pmgetSignature}
\title{Obtain the parameters for mutation signatures and memberships}
\usage{
pmgetSignature(
  mutationFeatureData,
  K,
  numInit = 10,
  tol = 1e-04,
  maxIter = 10000
)
}
\arguments{
\item{mutationFeatureData}{the mutation data (MutationFeatureData class 
(S4 class)) by the \code{hildaReadMPFile}.}

\item{K}{the number of mutation signatures}

\item{numInit}{the number of performing calculations with different initial 
values}

\item{tol}{tolerance for the estimation
(when the difference of log-likelihoods become below this value, stop 
the estimation)}

\item{maxIter}{the maximum number of iteration of estimation}
}
\value{
The output is an instance of EstimatedParameters S4 class, which 
        stores estimated parameters and other meta-information, and will be 
        used for saving parameter values and visualizing the mutation 
        signatures and memberships
}
\description{
Obtain the parameters for mutation signatures and memberships
}
\examples{
## After obtaining G (see e.g., hildaReadMPFile function)
load(system.file("extdata/sample.rdata", package="HiLDA"))
Param <- pmgetSignature(G, K = 3)


}
