% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilda_plot.R
\name{hildaPlotSignature}
\alias{hildaPlotSignature}
\title{Plot mutation signatures from HiLDA output}
\usage{
hildaPlotSignature(hildaResult, sigOrder = NULL, colorList = NULL, ...)
}
\arguments{
\item{hildaResult}{a rjags class output by HiLDA}

\item{sigOrder}{the order of signatures if needed (default: NULL)}

\item{colorList}{a vector of color for mutational exposures barplots}

\item{...}{additional arguments passed on to visPMS}
}
\value{
a plot object containing all mutational signatures
}
\description{
Plot mutation signatures from HiLDA output
}
\examples{

inputFile <- system.file("extdata/hildaLocal.rdata", package="HiLDA")
hildaLocal <- readRDS(inputFile)
hildaPlotSignature(hildaLocal)

}
