% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loops.R
\name{getLoops}
\alias{getLoops}
\title{Finding loops in contact map}
\usage{
getLoops(
  x,
  resolution = NULL,
  output_prefix = file.path("chromosight", "chromo"),
  norm = "auto",
  max.dist = "auto",
  min.dist = "auto",
  min.separation = "auto",
  n.mads = 5L,
  pearson = "auto",
  nreads = "no",
  ncores = 1L
)
}
\arguments{
\item{x}{A \code{HiCExperiment} object}

\item{resolution}{Which resolution to use to search loops}

\item{output_prefix}{Prefix to chromosight output (default: "chromosight/chromo")}

\item{norm}{Normalization parameter for chromosight}

\item{min.dist, max.dist}{Min and max distance to use to filter for significant
loops}

\item{min.separation}{Minimum separation between anchors of potential loops}

\item{n.mads}{Number of MADs to use to filter relevant bins to search for
loops}

\item{pearson}{Minimum Pearson correlation score to use to filter for
significant loops}

\item{nreads}{Number of reads to subsample to before searching for loops}

\item{ncores}{Number of cores for chromosight}
}
\value{
A \code{HiCExperiment} object with a new "loops" topologicalFeatures
storing significant interactions identified by chromosight, and an additional
\code{chromosight_args} metadata entry.
}
\description{
Find loops using chromosight
}
\examples{
contacts_yeast <- contacts_yeast()
contacts_yeast <- getLoops(contacts_yeast)
metadata(contacts_yeast)$chromosight_args
topologicalFeatures(contacts_yeast, 'loops')
}
