% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiCReport.R
\name{HiCReport}
\alias{HiCReport}
\title{HiC processing report}
\usage{
HiCReport(x, output = NULL)
}
\arguments{
\item{x}{an CoolFile object, generated from \code{HiCool::HiCool()} or
\code{HiCool::importHiCoolFolder()}, or directly from calling
\code{HiCExperiment::CoolFile()}.}

\item{output}{Path to save output HTML file.}
}
\value{
String to the generated HTML report file
}
\description{
HiC processing report
}
\examples{
mcool_path <- HiContactsData::HiContactsData('yeast_wt', 'mcool')
pairs_path <- HiContactsData::HiContactsData('yeast_wt', 'pairs.gz')
log_path <- HiContactsData::HiContactsData(sample = 'yeast_wt', format = 'HiCool_log')
cf <- CoolFile(mcool_path, pairs = pairs_path, metadata = list(log = log_path))
HiCReport(cf)
}
