% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{MD.plot1}
\alias{MD.plot1}
\title{Visualize the MD plot before and after loess normalization}
\usage{
MD.plot1(M, D, mc, smooth = TRUE)
}
\arguments{
\item{M}{The M component of the MD plot. Available from the
hic.table object.}

\item{D}{The D component of the MD plot. The unit distance of
the interaction. Available from the hic.table object.}

\item{mc}{The correction factor. Calculated by \code{hic_loess}.
Available from the hic.table object after running \code{hic_loess}.}

\item{smooth}{Should smooth scatter plots be used? If set to FALSE
ggplot scatter plots will be used. When option is TRUE, plots
generate quicker. It is recommend to use the smooth scatter
plots.}
}
\value{
An MD plot.
}
\description{
Visualize the MD plot before and after loess normalization
}
\examples{
# Create hic.table object using included Hi-C data in sparse upper
# triangular matrix format
data('HMEC.chr22')
data('NHEK.chr22')
hic.table <- create.hic.table(HMEC.chr22, NHEK.chr22, chr = 'chr22')
# Plug hic.table into hic_loess()
result <- hic_loess(hic.table)
MD.plot1(result$M, result$D, result$mc)

}
