% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MA_norm.R
\name{MA_norm}
\alias{MA_norm}
\title{Perform MA normalization on a hic.table object}
\usage{
MA_norm(
  hic.table,
  degree = 2,
  Plot = FALSE,
  span = NA,
  loess.criterion = "gcv"
)
}
\arguments{
\item{hic.table}{A hic.table object}

\item{degree}{The degree for loess normalization}

\item{Plot}{logical, should the MA plot be output?}

\item{span}{The span for loess. If left as the default value of NA the span will be calculated automatically}

\item{loess.criterion}{The criterion for calculating the span for loess}
}
\value{
An extended hic.table with adjusted IFs and M columns.
}
\description{
Perform MA normalization on a hic.table object
}
\details{
Performs loess normalization on the MA plot of the data.
}
\examples{
# create hic.table
data("HMEC.chr22")
data("NHEK.chr22")
hic.table <- create.hic.table(HMEC.chr22, NHEK.chr22, chr= 'chr22')
# Plug hic.table into MA_norm()
MA_norm(hic.table)
}
