% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionsByBaits.R
\name{interactionsByBaits}
\alias{interactionsByBaits}
\title{Filters HiCaptuRe object by baits}
\usage{
interactionsByBaits(interactions, baits, sep = ",", invert = FALSE)
}
\arguments{
\item{interactions}{a HiCaptuRe object}

\item{baits}{character vector containing bait names}

\item{sep}{character separating baits names when several baits in same fragment}

\item{invert}{TRUE/FALSE if need those interactions that do NOT contain the given baits}
}
\value{
The returned object includes a filtered set of interactions and updates the ByBaits slot with a tibble summarizing bait-wise interaction statistics (number of interactions, other ends, etc.). Baits that are not present in the interaction data will have empty statistics.
}
\description{
This function filters a HiCaptuRe object from load_interactions by a set of given bait(s)
}
\examples{
ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions <- load_interactions(ibed1, select_chr = "19")
baits <- c("ENST00000332235", "ENST00000516525")
interactions_baits <- interactionsByBaits(interactions = interactions, baits = baits)

}
