% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_density.R
\name{proposaldensity_combined}
\alias{proposaldensity_combined}
\title{Proposal Density Function for Model Components}
\usage{
proposaldensity_combined(params, component)
}
\arguments{
\item{params}{A numeric vector of parameters for which the proposal density is evaluated. The length and meaning
of these parameters are determined by the model and the selected component.}

\item{component}{An integer or identifier specifying which component’s proposal distribution should be used.
Each component has its own set of means and standard deviations defining the proposal distribution.
Valid components should match those defined within the function (e.g., 1, 2, or 3).}
}
\value{
A single numeric value representing the sum of the log proposal densities of all parameters for the specified component.
}
\description{
This function computes the proposal density under a given proposal distribution for a specified model component.
In a Bayesian MCMC framework, a proposal distribution is used to generate candidate parameter values in each iteration.
By evaluating the log-density of the proposed parameters under this distribution, the MCMC algorithm can determine
the acceptance or rejection of the new draw.
}
\details{
The function defines three components, each with its own proposal distribution parameters (means and standard deviations)
for a set of parameters. It then evaluates the log-density of the \code{params} vector under a multivariate normal
distribution (assuming independence between parameters), using the component-specific means and standard deviations.

Steps performed by the function:
\enumerate{
  \item Verifies that the specified \code{component} is valid and corresponds to one of the defined distributions.
  \item Extracts the mean and standard deviation vectors associated with that component.
  \item Checks that the length of \code{params} matches the expected length of the means and standard deviations.
  \item Evaluates the log of the normal probability density function (PDF) for each parameter using the corresponding
        mean and standard deviation.
  \item Sums these log-densities to produce the overall log-density of the proposal distribution for the parameter vector.
}

This function is used internally in our MCMC algorithms where proposals are drawn from component-specific Normal
distributions. By returning a log-probability, it simplifies calculations involved in Metropolis-Hastings updates
and related MCMC procedures.
}
\examples{

# Example usage:
# Suppose we have a parameter vector and want to compute its proposal density under component 2:
params <- c(0, 3, 5, 6, 1) # parameter vector
component <- 2
log_proposal <- proposaldensity_combined(params, component)
#print(log_proposal)


}
