% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-cool.R
\name{parse-cool}
\alias{parse-cool}
\alias{.getCoolAnchors}
\alias{.getCountsFromPair}
\alias{.getCounts}
\alias{.fetchCool}
\alias{.dumpCool}
\alias{.lsCoolFiles}
\alias{.lsCoolResolutions}
\alias{.cool2seqinfo}
\alias{.cool2gi}
\title{Parsing (m)cool files}
\usage{
.getCoolAnchors(file, resolution = NULL, balanced = "cooler")

.getCountsFromPair(file, pair, anchors, resolution = NULL)

.getCounts(file, coords, anchors, resolution = NULL)

.fetchCool(file, path, resolution = NULL, idx = NULL, ...)

.dumpCool(file, resolution = NULL)

.lsCoolFiles(file, verbose = FALSE)

.lsCoolResolutions(file, verbose = FALSE)

.cool2seqinfo(file, resolution = NULL)

.cool2gi(file, coords = NULL, resolution = NULL)
}
\arguments{
\item{file}{path to a Hi-C contact file (in (m)cool format)}

\item{resolution}{resolution of the contact matrix}

\item{balanced}{import balancing scores}

\item{pair}{Genomic coordinates to extract contacts for, stored as a Pairs
of GRanges (e.g.
S4Vectors::Pairs(GRanges("II:200000-300000"), GRanges("II:70000-100000"))).}

\item{anchors}{anchors from .getCoolAnchors()}

\item{coords}{Genomic coordinates to extract contacts for, stored as a
GRanges object}

\item{path}{Internal path of the cool file to check}

\item{idx}{Index to extract from the cool (HDF5) file}

\item{...}{Other arguments passed to .fetchCool}

\item{verbose}{Print resolutions in the console}
}
\value{
Silently, a numerical vector of resolutions stored in the cool file
}
\description{
These functions are the workhorse internal functions used to import
a \verb{.(m)cool} file as GInteractions (wrapped into a \code{HiCExperiment} object
by \code{HiCExperiment()} function).
}
\keyword{internal}
