% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeBiologicalBiases.R
\name{normalizeBiologicalBiases}
\alias{normalizeBiologicalBiases}
\title{Normalize biological biases.}
\usage{
normalizeBiologicalBiases(object, parallel = FALSE)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{parallel}{Should the normalization be run in parallel mode? Default to FALSE.}
}
\value{
A \code{\link{HiCDOCDataSet}} with normalized interactions.
}
\description{
Normalizes biological biases such as GC content and repeated regions. Uses
the Knight-Ruiz balancing algorithm to transform interaction matrices into
doubly stochastic matrices, with sum of each row and sum of each column equal
to 1.
}
\examples{
data(exampleHiCDOCDataSet)
object <- exampleHiCDOCDataSet
object <- filterSparseReplicates(object)
object <- filterWeakPositions(object)
object <- normalizeBiologicalBiases(object)

}
\seealso{
\code{\link{filterSparseReplicates}},
\code{\link{filterWeakPositions}},
\code{\link{normalizeTechnicalBiases}},
\code{\link{normalizeDistanceEffect}},
\code{\link{HiCDOC}}
}
