% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{HiCDOCDataSetFromTabular}
\alias{HiCDOCDataSetFromTabular}
\title{\code{\link{HiCDOCDataSet}} constructor from a tabular file.}
\usage{
HiCDOCDataSetFromTabular(path, sep = '\t')
}
\arguments{
\item{path}{A path to a tabular file.}

\item{sep}{The separator of the tabular file. Default to tabulation.}
}
\value{
A \code{\link{HiCDOCDataSet}}.
}
\description{
Constructs a \code{\link{HiCDOCDataSet}} from a tabular file.
}
\details{
Accepts a tabular file with \code{chromosome}, \code{position 1},
\code{position 2}, and multiple replicate columns listing interaction counts.
Null interactions do not have to be listed. Values must be separated by
tabulations. The header must be
\code{chromosome position 1 position 2 x.y x.y x.y ...} with \code{x}
replaced by condition names and \code{y} replaced by replicate names.
}
\examples{
path <- system.file("extdata", "liver_18_10M_500000.tsv", package = "HiCDOC")
object <- HiCDOCDataSetFromTabular(path, sep = '\t')

}
