% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/straw_dump.R
\name{straw_dump}
\alias{straw_dump}
\title{straw_dump}
\usage{
straw_dump(norm, fn, ch1, ch2, u, bs)
}
\arguments{
\item{norm}{Normalization to apply. Must be one of NONE/VC/VC_SQRT/KR.
VC is vanilla coverage, VC_SQRT is square root of vanilla coverage,
and KR is Knight-Ruiz or Balanced normalization.}

\item{fn}{path to the .hic file}

\item{ch1}{first chromosome location (e.g., "1")}

\item{ch2}{second chromosome location (e.g., "8")}

\item{u}{BP (BasePair) or FRAG (restriction enzyme FRAGment)}

\item{bs}{The bin size. By default, for BP, this is one of 
<2500000, 1000000, 500000,
250000, 100000, 50000, 25000, 10000, 5000> and for FRAG this is one of 
<500, 200,
100, 50, 20, 5, 2, 1>.}
}
\value{
Data.frame of a sparse matrix of data from hic file. x,y,counts
}
\description{
Interface for Juicer's dump in case C++ straw fails (known to fail on Windows
due to zlib compression not being OS agnostic and particularly not preserving
null bytes, which .hic files are delimited with). This function reads the 
.hic file, finds the appropriate matrix and slice of data, writes it to a 
temp file, reads and modifies it, and outputs as an R DataFrame (and also
deletes the temp file).
}
\details{
Usage: straw_dump <oe/observed> <NONE/VC/VC_SQRT/KR> <hicFile(s)> <chr1>[:x1:x2] <chr2>[:y1:y2] <BP/FRAG> <binsize> <outfile>
}
