% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hicdcdiff.R
\name{hicdcdiff}
\alias{hicdcdiff}
\title{hicdcdiff}
\usage{
hicdcdiff(
  input_paths,
  filter_file,
  output_path,
  bin_type = "Bins-uniform",
  binsize = 5000,
  granularity = 5000,
  chrs = NULL,
  Dmin = 0,
  Dmax = 2e+06,
  diagnostics = FALSE,
  DESeq.save = FALSE,
  fitType = "local"
)
}
\arguments{
\item{input_paths}{a list with names as condition names and values
as paths to \code{gi_list} RDS objects (see \code{?gi_list_validate}
for a detailed explanation of valid \code{gi_list} instances) 
saved with \code{saveRDS} or
paths to .hic files for each replicate. e.g.,\code{list(
CTCF=c('~/Downloads/GM_CTCF_rep1_MAPQ30_10kb.rds',
'~/Downloads/GM_CTCF_rep2_MAPQ30_10kb.rds'),
SMC=c('~/Downloads/GM_SMC_rep1_MAPQ30_10kb.rds',
'~/Downloads/GM_SMC_rep2_MAPQ30_10kb.rds'))}}

\item{filter_file}{path to the text file containing columns 
chr', startI, and
startJ denoting the name of the chromosomes and starting coordinates
of 2D interaction bins to be compared across conditions, respectively.}

\item{output_path}{the path to the folder and name prefix you want to
place DESeq-processed matrices (in a .txt file), plots
(if \code{diagnostics=TRUE}) and DESeq2 objects (if \code{DESeq.save=TRUE}).
Files will be generated for each chromosome.}

\item{bin_type}{'Bins-uniform' if uniformly binned by binsize in
bp, or 'Bins-RE-sites' if binned by number of
restriction enzyme fragment cutsites!}

\item{binsize}{binsize in bp if bin_type='Bins-uniform' (or number of
RE fragments if bin_type='Bins-RE-sites'), e.g., default 5000}

\item{granularity}{Desired distance granularity to base dispersion parameters
on in bp. For uniformly binned analysis 
(i.e., \code{bin_type=='Bins-uniform'}),
this defaults to the bin size. Otherwise, it is 5000.}

\item{chrs}{select a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to all chromosomes (except Y and M)
in the filter_file.}

\item{Dmin}{minimum distance (included) to check for significant interactions,
defaults to 0. Put Dmin=1 to ignore D=0 bins in calculating
normalization factors.}

\item{Dmax}{maximum distance (included) to check for significant interactions,
defaults to 2e6 or maximum in the data; whichever is minimum.}

\item{diagnostics}{if TRUE, generates diagnostic plots of the normalization
factors, geometric means of such factors by distance bin, as well as MA Plots
(see DESeq documentation for details about MA plots). Defaults to FALSE.}

\item{DESeq.save}{if TRUE, saves the DESeq objects for each chromosome
as an .rds file in the \code{output_path}. Defaults to FALSE.}

\item{fitType}{follows fitType in \code{DESeq2::estimateDispersions}.
Allowable options are 'parametric' (parametric regression),'local' 
(local regression), and 'mean' (constant across interaction bins). 
Default is 'local'.}
}
\value{
paths of a list of three entities.
\code{outputpaths} will have differential bins among those in filter_file.
\code{deseq2paths} will have the DESeq2 object stored as an .rds file.
Available if \code{DESeq.save=TRUE}
\code{plotpaths} will have diagnostic plots (e.g., MA, dispersion, PCA)
if \code{diagnostics=TRUE}.
}
\description{
This function calculates differential interactions for a
set of chromosomes across conditions and replicates. You need to install
\code{DESeq2} from Bioconductor to use this function.
}
\examples{
outputdir<-paste0(tempdir(check=TRUE),'/')
hicdcdiff(input_paths=list(NSD2=c(
system.file("extdata", "GSE131651_NSD2_LOW_arima_example.hic",
package = "HiCDCPlus"),
system.file("extdata", "GSE131651_NSD2_HIGH_arima_example.hic",
package = "HiCDCPlus")),
TKO=c(system.file("extdata", "GSE131651_TKOCTCF_new_example.hic",
package = "HiCDCPlus"),
system.file("extdata", "GSE131651_NTKOCTCF_new_example.hic",
package = "HiCDCPlus"))),
filter_file=system.file("extdata", "GSE131651_analysis_indices.txt.gz",
package = "HiCDCPlus"),
         chrs='chr22',
         output_path=outputdir,
         fitType = 'mean',
         binsize=50000,
         diagnostics=FALSE)
}
