% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hic2icenorm_gi_list.R
\name{hic2icenorm_gi_list}
\alias{hic2icenorm_gi_list}
\title{hic2icenorm_gi_list}
\usage{
hic2icenorm_gi_list(
  hic_path,
  binsize = 50000,
  chrs = NULL,
  hic_output = FALSE,
  gen = "Hsapiens",
  gen_ver = "hg19",
  Dthreshold = Inf
)
}
\arguments{
\item{hic_path}{Path to the .hic file.}

\item{binsize}{Desired bin size in bp (default 50000).}

\item{chrs}{select a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to chromosomes in \code{gen} and \code{gen_ver}
except 'chrY' and 'chrM'.}

\item{hic_output}{If TRUE, a .hic file with the name
\code{gsub("\\.hic$","_icenorm.hic",hic_path)} is generated containing the ICE
normalized counts under 'NONE' normalization.}

\item{gen}{name of the species: e.g., default \code{'Hsapiens'}}

\item{gen_ver}{genomic assembly version: e.g., default \code{'hg19'}}

\item{Dthreshold}{maximum distance (included) to check for significant
interactions, defaults to maximum in the data.}
}
\value{
a thresholded gi_list instance with ICE normalized intra-chromosomal
counts for further use with this package, HiCDCPlus.
}
\description{
This function converts a .hic file into a gi_list instance with ICE 
normalized counts on the counts column for TAD annotation using  a copy of
TopDom (see ?TopDom_0.0.2) as well as an (optional) .hic file with ICE
normalized counts for visualization with Juicebox. This function requires
installing the Bioconductor package \code{HiTC}.
}
\examples{
hic_path<-system.file("extdata", "GSE63525_HMEC_combined_example.hic",
package = "HiCDCPlus")
gi_list=hic2icenorm_gi_list(hic_path,binsize=50e3,chrs=c('chr22'))
}
