% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gi_list_write.R
\name{gi_list_write}
\alias{gi_list_write}
\title{gi_list_write}
\usage{
gi_list_write(
  gi_list,
  fname,
  chrs = NULL,
  columns = "minimal",
  rows = "all",
  significance_threshold = 0.05,
  score = NULL
)
}
\arguments{
\item{gi_list}{List of \code{GenomicInteractions} objects where each object
named with chromosomes contains intra-chromosomal interaction information
(see
\code{?gi_list_validate} for a detailed explanation of valid \code{gi_list}
instances).}

\item{fname}{path to the file to write to (can end with .txt, or .txt.gz).}

\item{chrs}{select a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to all chromosomes
in the \code{gi_list}.}

\item{columns}{Can be 'minimal', which is
just distance and counts (and \code{HiCDCPlus} result columns
'qvalue','pvalue','mu',and 'sdev', if exists; see \code{?HiCDCPlus})
information, 'minimal_plus_features', which is
distance, counts, and other calculated 2D features,
'minimal_plus_score', which generates a .hic pre compatible text file,
or 'all', which is
distance, counts, calculated 2D features, as well as all 1D features.
Defaults to 'minimal'.}

\item{rows}{Can be 'all' or 'significant', which filters rows according to 
FDR adjusted pvalue column 'qvalue' (this has to exist in \code{mcols(.)})
at \code{significance_threshold}. Defaults to 'all'.}

\item{significance_threshold}{Row filtering threshold on 'qvalue'.
Defaults to 0.05.}

\item{score}{Score column to extract to .hic pre compatible file.
See \code{mode} options in \code{?hicdc2hic} for more details.}
}
\value{
a tab separated flat file concatenating all intra-chromosomal
interaction information.
}
\description{
Writes a valid gi_list instance into a file.
}
\examples{
outputdir<-paste0(tempdir(check=TRUE),'/')
gi_list<-generate_binned_gi_list(1e6,chrs='chr22')
gi_list_write(gi_list,paste0(outputdir,'test.txt'))
}
