% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gi_list_binsize_detect.R
\name{gi_list_binsize_detect}
\alias{gi_list_binsize_detect}
\title{gi_list_binsize_detect}
\usage{
gi_list_binsize_detect(gi_list)
}
\arguments{
\item{gi_list}{gi_list object to be verified. In order to pass without errors, 
a gi_list object (1) has to be a list of InteractionSet::GInteractions
objects,(2) each list element has to be named as chromosomes and only contain
intra-chromosomal interaction information,
(3) \code{mcols(.)} for each list element should at least contain pairwise
genomic distances in a column named 'D' and (4) each list element needs to
be uniformly binned}
}
\value{
uniform binsize in base pairs or an error if the gi_list instance
is not uniformly binned.
}
\description{
This function finds the bin size of a uniformly binned valid gi_list instance
in bp. It raises an error if the gi_list instance is not uniformly binned.
}
\examples{
gi_list<-generate_binned_gi_list(1e6,chrs='chr22')
gi_list_binsize_detect(gi_list)
}
