% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrickContainer_functions.R
\name{load_BrickContainer}
\alias{load_BrickContainer}
\title{Create a BrickContainer object from a JSON file}
\usage{
load_BrickContainer(config_file = NULL, project_dir = NULL)
}
\arguments{
\item{config_file}{Default NULL
A character string of length 1 specifying the path to the path to the
configuration json created using \code{Create_many_bricks}}

\item{project_dir}{Default NULL
A character string of length 1 specifying the path to the path to the
configuration json created using \code{Create_many_bricks}}
}
\value{
An object of class BrickContainer
}
\description{
\code{load_BrickContainer} creates a BrickContainer object from a JSON file
}
\examples{

Bintable.path <- system.file("extdata",
"Bintable_100kb.bins", package = "HiCBricks")
out_dir <- file.path(tempdir(), "BrickContainer_load_test")
dir.create(out_dir)
Create_many_Bricks(BinTable = Bintable.path, 
  bin_delim = " ", output_directory = out_dir, file_prefix = "Test", 
  experiment_name = "Vignette Test", resolution = 100000, 
  remove_existing = TRUE)
My_BrickContainer <- load_BrickContainer(project_dir = out_dir)

}
