% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Create_many_Bricks_from_mcool}
\alias{Create_many_Bricks_from_mcool}
\title{Create the entire HDF5 structure and load the bintable from a mcool file}
\usage{
Create_many_Bricks_from_mcool(
    output_directory = NA,
    file_prefix = NA,
    mcool = NULL,
    resolution = NULL,
    experiment_name = NA,
    remove_existing = FALSE
)
}
\arguments{
\item{output_directory}{\strong{Required}
A string specifying the location where the HDF files will be created.}

\item{file_prefix}{\strong{Required}
A string specifying the prefix that is concatenated to the hdf files stored
in the output_directory.}

\item{mcool}{\strong{Required}. Path to an mcool file.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{experiment_name}{\strong{Optional}.
If provided, this will be the experiment name for the BrickContainer.}

\item{remove_existing}{\strong{Optional}. Default FALSE.
If TRUE, will remove the HDF file with the same name and create a new one.
By default, it will not replace existing files.}
}
\value{
This function will generate the target Brick file. Upon completion,
the function will provide the path to the created/tracked HDF file.
}
\description{
\code{Create_many_Bricks_from_mcool} is a wrapper on Create_many_Bricks which
creates the Brick data structure from an mcool file.
}
\details{
mcool are a standard 4D nucleome data structure for Hi-C data. Read more
about the 4D nucleome project \href{https://data.4dnucleome.org/}{here}.
}
\examples{

\dontrun{
require(curl)
out_dir <- file.path(tempdir(),"mcool_test_dir")
dir.create(path = out_dir)
curl_download(url = paste("https://data.4dnucleome.org/",
"files-processed/4DNFI7JNCNFB/",
"@download/4DNFI7JNCNFB.mcool", sep = ""),
destfile = file.path(out_dir,"H1-hESC-HiC-4DNFI7JNCNFB.mcool"))

mcool <- file.path(out_dir,"H1-hESC-HiC-4DNFI7JNCNFB.mcool")

Create_many_Bricks_from_mcool(output_directory = out_dir,
file_prefix = "Test",
mcool = mcool,
resolution = 50000,
experiment_name = "A random 4DN dataset")

}

}
\seealso{
\code{\link{Brick_load_data_from_mcool}} to load data from
the mcool to a Brick store.
}
