% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_rangekey_exists}
\alias{Brick_rangekey_exists}
\title{Check to see if the Brick contains a ranges with a certain name.}
\usage{
Brick_rangekey_exists(
    Brick,
    rangekey,
    resolution = NA,
    all_resolutions = FALSE
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{rangekey}{\strong{Required}.
A string specifying the name of the ranges to check for.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{all_resolutions}{\strong{Optional}. Default FALSE
If resolution is not defined and all_resolutions is TRUE, the resolution
parameter will be ignored and the function is executed on all files listed
in the Brick container}
}
\value{
A logical vector of length 1 with either TRUE or FALSE values.
}
\description{
\code{Brick_rangekey_exists} checks for the presence of a particular ranges with
a certain name.
}
\examples{

Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "list_rangekeys_exists_test")

dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)
Brick_rangekey_exists(Brick = My_BrickContainer, rangekey = "Bintable",
resolution = 100000)

}
