% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_load_data_from_mcool}
\alias{Brick_load_data_from_mcool}
\title{Load a NxN dimensional matrix into the Brick store from an mcool file.}
\usage{
Brick_load_data_from_mcool(
    Brick,
    mcool,
    resolution = NULL,
    matrix_chunk = 2000,
    cooler_read_limit = 1e+07,
    remove_prior = FALSE,
    norm_factor = "Iterative-Correction"
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{mcool}{\strong{Required}. Path to an mcool file.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{matrix_chunk}{\strong{Optional}. Default 2000.
The nxn matrix square to fill per iteration in a mcool file.}

\item{cooler_read_limit}{\strong{Optional}. Default 10000000.
cooler_read_limit sets the upper limit for the number of records per matrix
chunk. If the number of records per chunk is higher than this value, the
matrix_chunk value will be re-evaluated dynamically.}

\item{remove_prior}{\strong{Optional}. Default FALSE
If a matrix was loaded before, it will not be replaced. Use remove_prior to
override and replace the existing matrix.}

\item{norm_factor}{\strong{Optional}. Default "Iterative-Correction".
The normalization factor to use for normalization from an mcool file.
norm_factor currently accepts one of "Iterative-Correction", "Knight-Ruitz",
"Vanilla-coverage", "Vanilla-coverage-square-root" and NULL. If NULL,
the function will load only counts from the mcool file.}
}
\value{
Returns TRUE if all went well.
}
\description{
Read an mcool contact matrix coming out of 4D nucleome projects into a
Brick store.
}
\examples{

\dontrun{

require(curl)
out_dir <- file.path(tempdir(),"mcool_load_test")
dir.create(path = out_dir)
curl_download(url = paste("https://data.4dnucleome.org/",
"files-processed/4DNFI7JNCNFB/",
"@download/4DNFI7JNCNFB.mcool", sep = ""),
destfile = file.path(out_dir,"H1-hESC-HiC-4DNFI7JNCNFB.mcool"))

mcool <- file.path(out_dir,"H1-hESC-HiC-4DNFI7JNCNFB.mcool")

My_BrickContainer <- Create_many_Bricks_from_mcool(
output_directory = out_dir,
file_prefix = "Test",
mcool = mcool,
resolution = 50000,
experiment_name = "A random 4DN dataset")

Brick_load_data_from_mcool(Brick = My_BrickContainer, mcool = mcool,
resolution = 50000, matrix_chunk = 2000, remove_prior = TRUE,
norm_factor = "Iterative-Correction")

}


}
\seealso{
\code{\link{Create_many_Bricks_from_mcool}} to create matrix from
an mcool file, \code{\link{Brick_list_mcool_resolutions}} to list available
resolutions in an mcool file, \code{\link{Brick_list_mcool_normalisations}}
to list available normalisation factors in the mcool file.
}
