% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_load_cis_matrix_till_distance}
\alias{Brick_load_cis_matrix_till_distance}
\title{Load a NxN dimensional sub-distance \emph{cis} matrix into
the Brick store.}
\usage{
Brick_load_cis_matrix_till_distance(
    Brick = NA,
    chr = NA,
    resolution = NA,
    matrix_file,
    delim = " ",
    distance,
    remove_prior = FALSE,
    num_rows = 2000,
    is_sparse = FALSE,
    sparsity_bins = 100
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{chr}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the rows and cols of the matrix}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{matrix_file}{\strong{Required}.
A character vector of length 1 specifying the name of the file to load as a
matrix into the Brick store.}

\item{delim}{\strong{Optional}. Default " "
The delimiter of the matrix file.}

\item{distance}{\strong{Required}. Default NULL.
For very high-resolution matrices, read times can become extremely slow and
it does not make sense to load the entire matrix into the data structure, as
after a certain distance, the matrix will become extremely sparse. This
ensures that only interactions upto a certain distance from the main
diagonal will be loaded into the data structure.}

\item{remove_prior}{\strong{Optional}. Default FALSE
If a matrix was loaded before, it will not be replaced. Use remove_prior to
override and replace the existing matrix.}

\item{num_rows}{\strong{Optional}. Default 2000
Number of rows to insert per write operation in the HDF file.}

\item{is_sparse}{\strong{Optional}. Default FALSE
If true, designates the matrix as being a sparse matrix, and computes the
sparsity.index. The sparsity index measures the proportion of non-zero rows
or columns at a certain distance from the diagonal (100) in cis interaction
matrices.}

\item{sparsity_bins}{\strong{Optional}. Default 100
With regards to computing the sparsity.index, this parameter decides the
number of bins to scan from the diagonal.}
}
\value{
Returns TRUE if all went well.
}
\description{
Load a NxN dimensional sub-distance \emph{cis} matrix into
the Brick store.
}
\examples{

Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "matrix_load_dist_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
  bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
  experiment_name = "Vignette Test", resolution = 100000,
  remove_existing = TRUE)

Matrix_file <- system.file(file.path("extdata", 
"Sexton2012_yaffetanay_CisTrans_100000_corrected_chr2L.txt.gz"), 
package = "HiCBricks")

Brick_load_cis_matrix_till_distance(Brick = My_BrickContainer, 
chr = "chr2L", resolution = 100000, matrix_file = Matrix_file, 
delim = " ", distance = 30, remove_prior = TRUE)

}
