% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_list_matrix_mcols}
\alias{Brick_list_matrix_mcols}
\title{List the matrix metadata columns in the Brick store.}
\usage{
Brick_list_matrix_mcols()
}
\value{
Returns a vector containing the names of all matrix metadata columns
}
\description{
\code{Brick_get_matrix_mcols} will list the names of all matrix metadata
columns.
}
\examples{

Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "list_matrix_mcols_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Brick_list_matrix_mcols()
}
