% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_list_matrices}
\alias{Brick_list_matrices}
\title{List the matrix pairs present in the Brick store.}
\usage{
Brick_list_matrices(
    Brick,
    chr1 = NA,
    chr2 = NA,
    resolution = NA,
    all_resolutions = FALSE
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{chr1}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the rows of the matrix}

\item{chr2}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the columns of the matrix}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{all_resolutions}{\strong{Optional}. Default FALSE
If resolution is not defined and all_resolutions is TRUE, the resolution
parameter will be ignored and the function is executed on all files listed
in the Brick container}
}
\value{
Returns a data.frame object with columns chr1, chr2 corresponding
to chromosome pairs, and the associated attributes. filename corresponds to
the name of the file that was loaded for the pair. min and max specify the
minimum and maximum values in the matrix, done is a logical value
specifying if a matrix has been loaded and sparsity specifies if a matrix
is defined as a sparse matrix.
}
\description{
\code{Brick_list_matrices} will list all chromosomal pair matrices from the
Brick store, with their associated filename, value range, done status
and sparse
}
\examples{

Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "list_matrices_test")

dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Brick_list_matrices(Brick = My_BrickContainer, chr1 = "chr2L", 
chr2 = "chr2L", resolution = 100000)

}
