% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_get_bintable}
\alias{Brick_get_bintable}
\title{Returns the binning table associated to the Hi-C experiment.}
\usage{
Brick_get_bintable(Brick, chr = NA, resolution = NA)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{chr}{\strong{Optional}.
A chr string specifying the chromosome to select from the ranges.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}
}
\value{
Returns a GRanges object containing the binning
table associated to the Brick store.
}
\description{
\code{Brick_get_bintable} makes a call to \code{\link{Brick_get_ranges}} to
retrieve the binning table of the associated Brick store. This is equivalent
to passing the argument rangekey = "bintable" in
\code{\link{Brick_get_ranges}}
}
\examples{

Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "list_get_bintable_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Brick_get_bintable(Brick = My_BrickContainer, resolution = 100000)

}
\seealso{
Brick_get_ranges
}
