% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_call_compartments}
\alias{Brick_call_compartments}
\title{Identify compartments in the Hi-C data}
\usage{
Brick_call_compartments(Brick, chr, resolution)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{chr}{\strong{Required}.
A string specifying the chromosome for the cis Hi-C matrix from which values
will be retrieved at a certain distance.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}
}
\value{
A dataframe containing the chromosome genomic coordinates and the
first three principal components.
}
\description{
\code{Brick_call_compartments} identifies compartments in Hi-C data. Reference
Lieberman-Aiden et al. 2009.
}
\examples{
Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "get_vector_val_test")
if(!file.exists(out_dir)){
    dir.create(out_dir)
}

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Matrix_file <- system.file(file.path("extdata", 
"Sexton2012_yaffetanay_CisTrans_100000_corrected_chr2L.txt.gz"), 
package = "HiCBricks")

Brick_load_matrix(Brick = My_BrickContainer, chr1 = "chr2L", 
chr2 = "chr2L", matrix_file = Matrix_file, delim = " ", 
remove_prior = TRUE, resolution = 100000)

Compartments_df <- Brick_call_compartments(Brick = My_BrickContainer, 
chr = "chr2L", resolution = 100000)

}
