% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrickContainer_functions.R
\name{BrickContainer_get_path_to_file}
\alias{BrickContainer_get_path_to_file}
\title{Get the path to HDF files present in the Brick container.}
\usage{
BrickContainer_get_path_to_file(
    Brick = NULL,
    chr1 = NA,
    chr2 = NA,
    type = NA,
    resolution = NA
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created
with Create_many_Bricks.}

\item{chr1}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the rows of the matrix}

\item{chr2}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the columns of the matrix}

\item{type}{A value from one of cis, trans specifying the type of files to list
cis will list intra-choromosomal file paths and trans will list
inter-chromosomal file paths.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}
}
\value{
A vector containing filepaths
}
\description{
\code{BrickContainer_get_path_to_file} fetches the list of HDF file paths
associated to a particular BrickContainer
}
\examples{

Bintable.path <- system.file("extdata",
"Bintable_100kb.bins", package = "HiCBricks")

out_dir <- file.path(tempdir(), "BrickContainer_list_filepath_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
  bin_delim = " ", output_directory = out_dir, file_prefix = "Test", 
  experiment_name = "Vignette Test", resolution = 100000, 
  remove_existing = TRUE)

BrickContainer_get_path_to_file(Brick = My_BrickContainer, chr1 = "chr2L",
chr2 = "chr2L", resolution = 100000)

}
