% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrickContainer_functions.R
\name{BrickContainer_change_output_directory}
\alias{BrickContainer_change_output_directory}
\title{Change the location of HDF files in the BrickContainer object}
\usage{
BrickContainer_change_output_directory(Brick = NULL, output_directory = NULL)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with CreateBrick.}

\item{output_directory}{\strong{Required}. Default NULL
A string specifying new location of the output_directory. Please note,
that the location of the HDF files will not be changed.}
}
\value{
An object of class BrickContainer where the output_directory
has been changed
}
\description{
\code{BrickContainer_change_output_directory} changes the location of
associated HDF files
}
\examples{
Bintable.path <- system.file("extdata",
"Bintable_100kb.bins", package = "HiCBricks")

out_dir <- file.path(tempdir(), "BrickContainer_out_dir_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test", 
    experiment_name = "Vignette Test", resolution = 100000, 
    remove_existing = TRUE)

BrickContainer_change_output_directory(Brick = My_BrickContainer, 
output_directory = tempdir())
}
