% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmanresults.R
\name{harmanresults}
\alias{harmanresults}
\title{Harman results object}
\description{
The S3 object returned after running \code{\link{harman}}.
}
\details{
\code{harmanresults} is the S3 object used to store the results from
\code{\link{harman}}.
This object may be presented to summary and data exploration functions such
as \code{\link{plot.harmanresults}}
and \code{\link{summary.harmanresults}} as well as the
\code{\link{reconstructData}} function which creates a corrected matrix of
data with the batch effect removed.
}
\section{Slots}{

\describe{
\item{\code{factors}}{\code{A data.frame} of the \code{expt} and \code{batch}
vectors.}

\item{\code{parameters}}{The harman runtime parameters. See \code{\link{harman}}
for details.}

\item{\code{stats}}{Confidence intervals and the degree of correction for each
principal component.}

\item{\code{center}}{The centering vector returned by \code{\link{prcomp}} with
\code{center=TRUE}.}

\item{\code{rotation}}{The matrix of eigenvectors (by column) returned from
\code{\link{prcomp}}.}

\item{\code{original}}{The original PC scores returned by \code{\link{prcomp}}.}

\item{\code{corrected}}{The harman corrected PC scores.}
}}

\examples{
## HarmanResults
library(HarmanData)
data(OLF)
expt <- olf.info$Treatment
batch <- olf.info$Batch
olf.harman <- harman(as.matrix(olf.data), expt, batch)
plot(olf.harman)
summary(olf.harman)
pcaPlot(olf.harman, pc_x=2, pc_y=3)
pcaPlot(olf.harman, pc_x=2, pc_y=3, colBy='expt', pch=1)
olf.data.corrected <- reconstructData(olf.harman)
}
\seealso{
\code{\link{harman}}, \code{\link{reconstructData}},
\code{\link{pcaPlot}}, \code{\link{arrowPlot}}
}
