% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callHarman.R
\name{callHarman}
\alias{callHarman}
\alias{.callHarman}
\title{Wrapper function to call the shared C/C++ library code}
\usage{
.callHarman(
  pc_data_scores,
  group,
  limit,
  numrepeats,
  randseed,
  forceRand,
  printInfo
)
}
\arguments{
\item{pc_data_scores}{2D NumericMatrix of PCA scores data (from the
\code{prcomp$x} slot), rows = samples, cols = PC scores}

\item{group}{The structure of the experiment, consisting of batch numbers and
treatment numbers forming 2 rows or columns (HarmanMain works out which).
Each entry for a sample describes what batch it came from and what treatment
it was given. Has to be integer formated data.}

\item{limit}{A double precsion value indicating the limit of confidence in
which to stop removing a batch effect}

\item{numrepeats}{The number of repeats in which to run the simulated batch
mean distribution estimator. Probably should be greater than 100,000.}

\item{randseed}{Random seed to pass to the random number generator (0 for use
default from system time)}

\item{forceRand}{Force algorithm}

\item{printInfo}{Print update information to screen}
}
\value{
SEXP R list
\itemize{
  \item scores.corrected
  \item correction
  \item confidence
}
}
\description{
This wrapper should probably not be addressed directly except
for debugging. Instead use \code{\link{harman}}. Input of PCA scores and the
experiment structure (treatments and batches) and returns a batch corrected
version of the PCA scores matrix.
}
\note{
A data matrix with samples in columns must be transposed before PCA
analysis and these scores in turn are tweaked a little before handing over
to \code{.callHarman}. See the example below.
}
