% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_imp.R
\name{var_imp}
\alias{var_imp}
\title{Variable Importance Plot}
\usage{
var_imp(x, cex.x = 1, cex.y = 2)
}
\arguments{
\item{x}{A list of elements returned from RFE analysis.
See \code{\link[caret]{rfe}} for more details}

\item{cex.x}{The size of x axis label.}

\item{cex.y}{The size of y axis label.}
}
\value{
Variable Importance Plot.
}
\description{
A graphical display of variable importance of selected
features.
}
\details{
var_imp
}
\examples{
data('example_data')
x <- na.omit(example_data)
#perform feature selection
s <- FSmethod(x, type = 'both',
cor.cutoff = 0.7, resampling.method = "repeatedcv",
iter = 5, repeats = 3, metric = "ROC", verbose = TRUE)
var_imp(s$rf.result$rfProfile, cex.x = 10, cex.y = 10)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}.
}
