% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gold_ReferenceSet.R
\docType{data}
\name{Gold_ReferenceSet}
\alias{Gold_ReferenceSet}
\title{Gold-standard Reference Set of Inter-Species PPIs}
\format{
a data.frame containing 500 validated pairs
(i.e., positive set) and 500 non-interacting pairs (i.e., negative set).
}
\source{
\url{https://www.biorxiv.org/content/10.1101/2020.09.03.282103v1}
}
\usage{
data(Gold_ReferenceSet)
}
\description{
This dataset consists of experimentally validated
human-SARS-CoV-2 interactions (positive set) and
non-interacting pairs (negative set).
The following data consists of:
\itemize{
  \item PPI: SARS-CoV-2-human protein-protein interactions (PPIs)
  \item Official Symbol Interactor A: SARS-CoV-2 gene names
  \item official Symbol Interactor B: human host gene names
  \item Pathogen_Protein: UniProt identifiers for SARS-CoV-2 virus
  \item Host_Protein: UniProt identifiers for human proteins
  \item class: labeled examples (both positive and negative)
}
}
\details{
To construct this dataset, validated interactions (positive set) were
retrieved from BioGrid database and were further filtered to only include
those interactions provided by (Samavarchi-Tehrani et al., 2020).
In this study, the authors mapped interaction between 27 SARS-CoV-2 and
human proteins via the proximity-dependent biotinylation (BioID)
approach. 500 SARS-CoV-2-host interaction pairs then randomly
selected from all pairs to serve as positive examples.
To construct negative examples,negative sampling were used using
\code{\link[HPiP]{get_negativePPI}}.
}
\references{
Samavarchi-Tehrani,P. et al.
(2020) A SARS-CoV-2-host proximity interactome. BioRxiv.
}
