% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSmethod.R
\name{FSmethod}
\alias{FSmethod}
\title{Feature Selection via Matrix Correlation and
Recursive Feature Elimination (RFE)}
\usage{
FSmethod(
  x,
  type = c("cor", "rfe", "both"),
  cor.cutoff = 0.7,
  resampling.method = "cv",
  iter = 2,
  repeats = 3,
  metric = "Accuracy",
  verbose = TRUE
)
}
\arguments{
\item{x}{A data.frame containing protein-protein interactions,
class labels and features.}

\item{type}{The feature selection type, one or two of
\code{filter.corr} and \code{rfeFS}.}

\item{cor.cutoff}{Correlation coefficient cutoff used for filtering.
See \code{filter.corr} for more details.}

\item{resampling.method}{The resampling method for RFE :'boot',
'boot632', optimism_boot',boot_all', 'cv', 'repeatedcv', 'LOOCV',
'LGOCV';defaults to cv. See \code{rfeFS} and
\code{\link[caret]{rfeControl}} for more details.}

\item{iter}{Number of partitions for cross-validation;
defaults to 2. See \code{rfeFS} and \code{\link[caret]{rfeControl}}
for more details.}

\item{repeats}{For repeated k-fold cross validation only;
defaults to 3.See \code{rfeFS} and \code{\link[caret]{rfeControl}}
for more details.}

\item{metric}{A string that specifies what summary metric will be used
to select the optimal feature ; default to ROC.See \code{rfeFS} and
\code{\link[caret]{rfe}} for more details.}

\item{verbose}{Make the output verbose.See \code{rfeFS} and
\code{\link[caret]{rfeControl}} for more details.}
}
\value{
If the type set to \code{filter.corr} , the output includes
the following elements:
\itemize{
\item{corProfile} - A correlation matrix.
\item{corSelectedFeatures} - Name of features that retained after
the correlation analysis.
\item{cordf} - A data.frame filtered.
}
If the type set to \code{rfeFS} , the output includes the following
elements:
\itemize{
\item{rfProfile} - A list of elements. See \code{\link[caret]{rfe}} for
more details.
\item{rfSelectedFeatures} - Name of features that retained in the feature
selection process.
\item{rfdf} - A data.frame filtered.
}
If type set to \code{both} the output includes the following elements:
\itemize{
\item{rfdf} - The final data.frame that includes the selected features
retained after both \code{filter.corr} and \code{rfeFS} analysis.
}
}
\description{
This function performs feature selections
via two approaches
\itemize{
\item \code{filter.corr} - compute matrix correlation between features
and filter using a threshold.
\item \code{rfeFS} - perform recursive feature elimination (RFE) method
wrapped with a Random Forest (RF) algorithm for feature importance
evaluation.
}
}
\details{
FSmethod
}
\examples{
data('example_data')
x <- na.omit(example_data)
s <- FSmethod(x, type = 'both',
cor.cutoff = 0.7, resampling.method = "repeatedcv",
iter = 5, repeats = 3, metric = "ROC", verbose = TRUE)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}.
}
