% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml.R
\name{hpaXmlTissueExprSum}
\alias{hpaXmlTissueExprSum}
\title{Extract tissue expression and download images}
\usage{
hpaXmlTissueExprSum(importedXml, downloadImg = FALSE)
}
\arguments{
\item{importedXml}{Input an xml document object resulted from a
\code{hpaXmlGet()} call.}

\item{downloadImg}{Logical argument. The function will download all image
from the extracted urls into the working folder.}
}
\value{
This function return a list consists of a summary string, which is a
  very brief description of the protein, and a tibble of 2 columns: tissue
  (name of tissue available) and imageUrl (link to download the perspective
  image)
}
\description{
Extract tissue expression information and url to download images from
imported xml document resulted from \code{hpaXmlGet()}.  It is important to
note that the data that HPA provides on their website and through xml files
are not one-to-one equivalents.
}
\examples{
  GCH1xml <- hpaXmlGet('ENSG00000131979')
  hpaXmlTissueExprSum(GCH1xml)

}
\seealso{
Other xml functions: 
\code{\link{hpaXml}()},
\code{\link{hpaXmlAntibody}()},
\code{\link{hpaXmlGet}()},
\code{\link{hpaXmlProtClass}()},
\code{\link{hpaXmlTissueExpr}()}
}
\concept{xml functions}
