% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml.R
\name{hpaXmlAntibody}
\alias{hpaXmlAntibody}
\title{Extract antibody information}
\usage{
hpaXmlAntibody(importedXml)
}
\arguments{
\item{importedXml}{Input an xml document object resulted from a
\code{hpaXmlGet()} call.}
}
\value{
This function returns a tibble of 4 columns, containing information
  about the antibodies used in the project for the inquired protein: id,
  releaseDate, releaseVersion, and RRID.
}
\description{
Extract information about the antibodies used for a specific protein.  It is
important to note that the data that HPA provides on their website and
through xml files are not one-to-one equivalents.
}
\examples{
  GCH1xml <- hpaXmlGet('ENSG00000131979')
  hpaXmlAntibody(GCH1xml)

}
\seealso{
Other xml functions: 
\code{\link{hpaXml}()},
\code{\link{hpaXmlGet}()},
\code{\link{hpaXmlProtClass}()},
\code{\link{hpaXmlTissueExpr}()},
\code{\link{hpaXmlTissueExprSum}()}
}
\concept{xml functions}
