% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{hpaVisTissue}
\alias{hpaVisTissue}
\title{Visualize tissue data}
\usage{
hpaVisTissue(
  data = NULL,
  targetGene = NULL,
  targetTissue = NULL,
  targetCellType = NULL,
  color = c("#FCFDBF", "#FE9F6D", "#DE4968", "#8C2981"),
  customTheme = FALSE
)
}
\arguments{
\item{data}{Input the list object generated by \code{hpa_download()} or
\code{hpa_subset()}. Require the \code{normal_tissue} dataset. Use HPA
histology data (built-in) by default.}

\item{targetGene}{Vector of strings of HGNC gene symbols. By default it is
set to \code{c('TP53', 'EGFR', 'CD44', 'PTEN')}. You can also mix
HGNC gene symbols and ensemnl ids (start with ENSG) and they will be
converted to HGNC gene symbols.}

\item{targetTissue}{Vector of strings of normal tissues. Default to all.}

\item{targetCellType}{Vector of strings of normal cell types. Default to all.}

\item{color}{Vector of 4 colors used to depict different expression levels.}

\item{customTheme}{Logical argument. If \code{TRUE}, the function will return
a barebone ggplot2 plot to be customized further.}
}
\value{
This function will return a ggplot2 plot object, which can be further
  modified if desirable. The tissue data is visualized as a heatmap: x axis
  contains inquired protein and y axis contains tissue/cells of interest.
}
\description{
Visualize the expression of protein of interest in each target tissue by cell
types.
}
\examples{
  data("hpa_histology_data")
  geneList <- c('TP53', 'EGFR', 'CD44', 'PTEN', 'IDH1', 'IDH2', 'CYCS')
  tissueList <- c('breast', 'cerebellum', 'skin 1')

  ## A typical function call
  hpaVisTissue(data=hpa_histology_data,
               targetGene=geneList,
               targetTissue=tissueList)

}
\seealso{
Other visualization functions: 
\code{\link{hpaVis}()},
\code{\link{hpaVisPatho}()},
\code{\link{hpaVisSubcell}()}
}
\concept{visualization functions}
