\name{HMMcopy example dataset}
\docType{data}

\alias{HMMcopy-dataset}
\alias{tumour}
\alias{tumour_reads}
\alias{tumour_copy}
\alias{normal_copy}
\alias{tumour_param}
\alias{tumour_segments}
\title{HMMcopy example dataset}
\usage{
  data(tumour)
}

\description{
  A set of data of chromosome 6 of matched tumour normal pair.
  The dataset that is described here belongs to a female triple-negative breast cancer 
patient from the dataset published in \cite{Shah2012,Ha2012}. This genome library was
sequenced on the ABI/Life SOLiD platform, generating hybrid lengths of 25bp and 50bp 
paired-end reads.  The reads were aligned using BioScope 
\url{https://products.appliedbiosystems.com/} where reads mapped to multiple sites
were ignored.

  \describe{
   \item{tumour_reads}{The number of short reads in fixed width windows across
    the chromosome, generated with \code{\link{wigsToRangedData}} from WIG files}
   \item{tumour_copy}{Tumour copy number profile generated by correcting
    \sQuote{tumour_reads} with \code{\link{correctReadcount}}}
   \item{normal_copy}{Normal copy number profile generated via
    \code{\link{correctReadcount}}}
    \item{tumour_param}{Parameters for segmenting \sQuote{tumour_copy} in
    \code{\link{HMMsegment}}}
  \item{tumour_segments}{Segmented output of \sQuote{tumour_copy} \code{\link{HMMsegment}}}
  using \sQuote{tumour_param}}
}


\format{
  \sQuote{tumour_reads}, \sQuote{tumour_copy}, and \sQuote{normal_copy} are
  \code{\link[IRanges:RangedData-class]{RangedData}} objects.

  \sQuote{tumour_param} is a numeric matrix.

  \sQuote{tumour_segments} is a list.
}

\references{
Gavin Ha, Andrew Roth, Daniel Lai, Ali Bashashati, Jiarui Ding, Rodrigo Goya, Ryan 
Giuliany, Jamie Rosner, Arusha Oloumi, Karey Shumansky, Suet-Feung Chin, Gulisa 
Turashvili, Martin Hirst, Carlos Caldas, Marco A Marra, Samuel Aparicio, and Sohrab 
P Shah. Integrative analysis of genome-wide loss of heterozygosity and mono-allelic 
expression at nucleotide resolution reveals disrupted pathways in triple negative 
breast cancer. Genome Research, (advanced online publication), May 2012.

S P Shah, A Roth, R Goya, A Oloumi, G Ha, Y Zhao, G Turashvili, J Ding, K Tse, G Hafari,
A Bashashati, L M Prentice, J Khattra, A Burleigh, D Yap, V Bernard, A McPherson, K Shuman-
sky, A Crisan, R Giuliany, A Heravi-Moussavi, J Rosner, D Lai, I Birol, R Varhol, A Tam, N Dhalla,
T Zeng, K Ma, S K Chan, M Griffth, A Moradian, S W Cheng, G B Morin, P Watson, K Gelmon,
S Chia, S F Chin, C Curtis, O M Rueda, P D Pharoah, S Damaraju, J Mackey, K Hoon, T Harkins,
V Tadigotla, M Sigaroudinia, P Gascard, T Tlsty, J F Costello, I M Meyer, C J Eaves, W W Wasserman,
S Jones, D Huntsman, M Hirst, C Caldas, M A Marra, and S Aparicio. The clonal and mutational
evolution spectrum of primary triple-negative breast cancers. Nature, 486(7403):395-399, Jun 2012.

}

\keyword{datasets}

