% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hippo.R
\name{hippo_tsne_plot}
\alias{hippo_tsne_plot}
\title{visualize each round of hippo through t-SNE}
\usage{
hippo_tsne_plot(sce, k = NA, pointsize = 0.5, pointalpha = 0.5, plottitle = "")
}
\arguments{
\item{sce}{SincleCellExperiment object with hippo and t-SNE
result in it}

\item{k}{number of rounds of clustering that you'd like to see result.
Default is 1 to K}

\item{pointsize}{size of the point for the plot (default 0.5)}

\item{pointalpha}{transparency level of points for the plot (default 0.5)}

\item{plottitle}{title for the ggplot output}
}
\value{
ggplot object for t-SNE in each round
}
\description{
visualize each round of hippo through t-SNE
}
\examples{
data(toydata)
set.seed(20200321)
toydata = hippo(toydata,K = 10,z_threshold = 1,outlier_proportion = 0.01)
toydata = hippo_dimension_reduction(toydata, method="tsne")
hippo_tsne_plot(toydata)
}
