% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel.R
\name{makeProteinCalls}
\alias{makeProteinCalls}
\title{Make Protein-level Calls}
\usage{
makeProteinCalls(prot_ds, padj_cutoff = 0.05, one_hit_filter = FALSE)
}
\arguments{
\item{prot_ds}{HERONProteinDataSet with the "padj" assay}

\item{padj_cutoff}{cutoff to use}

\item{one_hit_filter}{use the one-hit filter?}
}
\value{
HERONProteinDataSet with the "calls" assay added
}
\description{
Make Protein-level Calls
}
\examples{
data(heffron2021_wuhan)
seq_pval_res <- calcCombPValues(heffron2021_wuhan)
pr_pval_res <- convertSequenceDSToProbeDS(seq_pval_res)
pr_calls_res <- makeProbeCalls(pr_pval_res)
epi_segments_uniq_res <- findEpitopeSegments(
    PDS_obj = pr_calls_res,
    segment_method = "unique"
)
epi_padj_uniq <- calcEpitopePValues(
    probe_pds = pr_calls_res,
    epitope_ids = epi_segments_uniq_res,
    metap_method = "wilkinsons_max1"
)
prot_padj_uniq <- calcProteinPValues(
    epitope_ds = epi_padj_uniq,
    metap_method = "tippetts"
)
prot_calls <- makeProteinCalls(prot_padj_uniq)
}
