% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel.R
\name{getKofN}
\alias{getKofN}
\title{Get K of N statistics from an experiment with padj and calls}
\usage{
getKofN(obj)
}
\arguments{
\item{obj}{HERON Dataset with a "calls" assay}
}
\value{
DataFrame with K (#calls), F (fraction calls), P (%Calls)
}
\description{
Calculates the number of samples (K), the frequency
of samples (F), and the percentage of samples (P) called.
If the colData DataFrame contains a condition column with at least two
conditions, then a K, F, and P is calculated for each condition and the
results are reported as separate columns.
}
\examples{
data(heffron2021_wuhan)
seq_pval_res <- calcCombPValues(heffron2021_wuhan)
pr_pval_res <- convertSequenceDSToProbeDS(seq_pval_res)
pr_calls_res <- makeProbeCalls(pr_pval_res)
getKofN(pr_calls_res)
}
