% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{calcProteinPValues}
\alias{calcProteinPValues}
\title{Calculate protein-level p-values}
\usage{
calcProteinPValues(epitope_ds, metap_method = "wmin1", p_adjust_method = "BH")
}
\arguments{
\item{epitope_ds}{HERONEpitopeDataSet with the "pvalue" assay}

\item{metap_method}{meta p-value method to use}

\item{p_adjust_method}{p.adjust method to use}
}
\value{
HERONProteinDataSet with the "pvalue" and "padj" assays
}
\description{
Calculate protein-level p-values
}
\details{
see calcEpitopePValues for a list of meta p-value methods supported
by HERON. the protein should be one that requires at least one of the
epitope p-values to be small (e.g. wmax1).
}
\examples{
data(heffron2021_wuhan)
pval_seq_res <- calcCombPValues(heffron2021_wuhan)
pval_pr_res <- convertSequenceDSToProbeDS(pval_seq_res)
calls_res <- makeProbeCalls(pval_pr_res)
segments_res <- findEpitopeSegments(calls_res, "unique")
epval_res <- calcEpitopePValues(calls_res, segments_res)
ppval_res <- calcProteinPValues(epval_res)
}
\seealso{
[stats::p.adjust()] for p_adjust_parameter.

[calcEpitopePValues()] for meta p-value methods
}
