% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimmaXY.R
\name{glimmaXY}
\alias{glimmaXY}
\title{Glimma XY Plot}
\usage{
glimmaXY(
  x,
  y,
  xlab = "x",
  ylab = "y",
  dge = NULL,
  counts = dge$counts,
  groups = dge$samples$group,
  status = rep(0, length(x)),
  anno = NULL,
  display.columns = NULL,
  status.cols = c("#1052bd", "silver", "#cc212f"),
  sample.cols = NULL,
  transform.counts = c("logcpm", "cpm", "rpkm", "none"),
  main = "XY Plot",
  html = NULL,
  width = 920,
  height = 920
)
}
\arguments{
\item{x}{numeric vector of values to plot on the x-axis of the summary plot.}

\item{y}{numeric vector of values to plot on the y-axis of the summary plot.}

\item{xlab}{character string for the x-axis label of summary plot.}

\item{ylab}{character string for the y-axis label of summary plot.}

\item{dge}{\code{DGEList} object with \code{length(x)} rows from which expression values are
extracted from to create expression (right) plot. Gene counts are taken from \code{dge$counts}
and sample groups from \code{dge$samples$group}.}

\item{counts}{numeric matrix with \code{length(x)} rows containing gene expression values. This can be used to replace
raw gene counts from dge$counts with transformed counts e.g. logCPM or logRPKM values.}

\item{groups}{vector of length \code{ncol(counts)} representing categorisation of samples in expression plot.}

\item{status}{vector of length \code{length(x)} indicating the status of each gene.
A value of -1 marks a down-regulated gene, 0 marks a gene with no expression difference, and
1 marks an up-regulated gene.}

\item{anno}{dataframe with \code{length(x)} rows containing gene annotations.}

\item{display.columns}{character vector containing names of columns from \code{anno} from
which to display in mouseover tooltips and table.}

\item{status.cols}{vector of length 3 containing valid CSS strings for colours associated
with \code{status}  in the order of -1, 0 and 1.}

\item{sample.cols}{character vector of length \code{ncol(counts)} containing valid CSS strings
for colours associated with each sample to be displayed on the expression plot. If left
unspecified, samples will be coloured according to \code{groups}.}

\item{transform.counts}{the type of transformation used on the counts - "logcpm" for using \code{edgeR::cpm(counts, log=TRUE)};
"cpm" for \code{edgeR::cpm(counts)}; "rpkm" for \code{edgeR::rpkm(counts)}; "logrpkm" for \code{edgeR::rpkm(counts, log=TRUE)}; and "none" for no transformation). Defaults to "logcpm".}

\item{main}{character string for the main title of summary plot.}

\item{html}{character string for naming HTML file for exportation of widget. The extension
should be included in the file name e.g. "file.html".}

\item{width}{numeric value indicating width of widget in pixels.}

\item{height}{numeric value indicating width of height in pixels.}
}
\value{
htmlwidget object or \code{NULL} if \code{html} argument is specified.
}
\description{
Draws a two-panel interactive XY scatter plot.
}
\details{
The summary plot on the left displays the x and y values specified.
    The expression plot on the right displays sample expression values for a single gene.
    Interactions with the htmlwidget include clicking on genes (points) in the summary plot to bring up
    associated sample expression values in the expression plot, as well as the summary statistics in the table below.
    Alternatively, users can interact with the table by clicking on genes (rows) to highlight genes in the summary plot,
    as well as bring up associated sample expression values in the expression plot.
    Briefly, other interactive features include a search box for the table, buttons to save plots and data
    (summary statistics and expression values), additional pop-up information when hovering on points in plots,
    and rescaling of the y-axis in the expression plot.
}
\examples{
dge <- readRDS(
  system.file("RNAseq123/dge.rds", package = "Glimma"))
design <- readRDS(
  system.file("RNAseq123/design.rds", package = "Glimma"))
contr.matrix <- readRDS(
  system.file("RNAseq123/contr.matrix.rds", package = "Glimma"))

v <- limma::voom(dge, design)
vfit <- limma::lmFit(v, design)
vfit <- limma::contrasts.fit(vfit, contrasts = contr.matrix)
efit <- limma::eBayes(vfit)

glimmaXY(efit$Amean, efit$coefficients)

}
\author{
Hasaru Kariyawasam, Shian Su and Oliver Voogd
}
