% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimmaVolcano.R
\name{glimmaVolcano}
\alias{glimmaVolcano}
\title{Glimma Volcano Plot}
\usage{
glimmaVolcano(x, ...)
}
\arguments{
\item{x}{the DE object to plot.}

\item{...}{additional arguments affecting the plots produced. See specific methods for detailed arguments.}
}
\value{
htmlwidget object or \code{NULL} if \code{html} argument is specified.
}
\description{
Generic function for drawing a two-panel interactive volcano plot, a special case of the
glimmaXY plot.
The function invokes the following methods which depend on the class of the first argument:
\itemize{
  \item \code{\link{glimmaVolcano.MArrayLM}} for limma analysis
  \item \code{\link{glimmaVolcano.DGEExact}} for edgeR analysis, produced from \code{\link{exactTest}}
  \item \code{\link{glimmaVolcano.DGELRT}} for edgeR analysis, produced from \code{\link{glmLRT}}
  \item \code{\link{glimmaVolcano.DESeqDataSet}} for DESeq2 analysis }
}
\details{
The summary plot on the left represents gene-wise log-fold-change (logFC) on the x-axis versus
    \code{-log10(pvalue)}. The expression plot on the right displays sample expression values for a single gene.
    Interactions with the htmlwidget include clicking on genes (points) in the summary plot to bring up
    associated sample expression values in the expression plot, as well as the summary statistics in the table below.
    Alternatively, users can interact with the table by clicking on genes (rows) to highlight genes in the summary plot,
    as well as bring up associated sample expression values in the expression plot.
    Briefly, other interactive features include a search box for the table, buttons to save plots and data
    (summary statistics and expression values), additional pop-up information when hovering on points in plots,
    and rescaling of the y-axis in the expression plot.
}
\examples{
dge <- readRDS(
  system.file("RNAseq123/dge.rds", package = "Glimma"))
design <- readRDS(
  system.file("RNAseq123/design.rds", package = "Glimma"))
contr.matrix <- readRDS(
  system.file("RNAseq123/contr.matrix.rds", package = "Glimma"))

v <- limma::voom(dge, design)
vfit <- limma::lmFit(v, design)
vfit <- limma::contrasts.fit(vfit, contrasts = contr.matrix)
efit <- limma::eBayes(vfit)

glimmaVolcano(efit, dge = dge)

}
\author{
Hasaru Kariyawasam, Shian Su and Oliver Voogd
}
