% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxReport.R
\name{gtoxReport}
\alias{gtoxReport}
\title{Generate a report}
\usage{
gtoxReport(type, asid, params = NULL, odir = getwd(), report_author,
  report_title = "Report", sumfile = NULL,
  keep.intermediates = FALSE)
}
\arguments{
\item{type}{The type of report to generate}

\item{asid}{The assay source/study ID}

\item{params}{Named list containing report type-specific parameters, see
details}

\item{odir}{The output directory}

\item{report_author}{The author for the report}

\item{report_title}{The title for the report}

\item{sumfile}{Path to a text file that inserts into the report}

\item{keep.intermediates}{TRUE/FALSE, keep intermediate files when TRUE}
}
\value{
None
}
\description{
\code{gtoxReport} generates a report.
}
\details{
'type' can have three values, "all," "compare," or "qc." Each report
contains slightly different elements, but in general:
\itemize{
\item "all" -- summarizes the results for all or some compounds
  \itemize{
  \item "chids" -- (optional) a vector of chid values to report, rather than
  all available compounds
  }
\item "compare" -- compares the results for two compounds
  \itemize{
  \item "c1" -- (required) the chid for the first compound to compare
  \item "c2" -- (required) the chid for the second compound to compare
  }
\item "qc" -- summarizes low-level data for quality control purposes
  \itemize{
  \item "aids" -- (optional) a vector of aid values to report, rather than
  all available assays
  }
}

The required list elements vary depending on the type of report, and are
described under the report descriptions above.

'sumfile' allows the user to inject a Tex file into the report. The
file contents will be inserted into the Study Overview section, immediately
after the autogenerated text. Technically, 'sumfile' is brewed, so 'sumfile'
can make use of brew and Sweave syntax, and all data loaded for the report.
}
\examples{
## Generate full analysis report

\dontrun{
## Generate report
gtoxReport(type = "all", asid = 1L, report_author = "author", 
report_title = "Processing report")
}

}
