% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignDefaultMthds.R
\name{assignDefaultMthds}
\alias{assignDefaultMthds}
\title{Assign default processing methods}
\usage{
assignDefaultMthds(asid, params = NULL)
}
\arguments{
\item{asid}{Integer, the asid value(s) to which assign the default methods}

\item{params}{Parameters for level 2, 3, and 5 processing}
}
\value{
None
}
\description{
Function to assign default processing method to asid in input
}
\details{
This function loads all components and endpoints for the given asid(s) in
the database, and assigns a default set of processing methods to them.

This funciton will overwrite any previously assigned methods.

By default, each assay will receive 'none' at level 2. Level 3 data will
receive, in order, 'bval.pmi' (39), 'resp.fc' (9), 'resp.log2' (7), and
for endpoints with "down" analysis direction, 'resp.multneg1' (6).
}
\examples{

## Prepare for analysis before QC + process data
assignDefaultMthds(asid = 1L)

## Process data
gtoxRun(asid = 1L, slvl = 1, elvl = 6, mc.cores = 2)

}
